/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.erasurecode.rawcoder;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hadoop.io.erasurecode.ECChunk;
import org.apache.hadoop.io.erasurecode.ErasureCodeNative;
import org.apache.hadoop.io.erasurecode.rawcoder.CoderUtil;
import org.apache.hadoop.io.erasurecode.rawcoder.DecodingValidator;
import org.apache.hadoop.io.erasurecode.rawcoder.InvalidDecodingException;
import org.apache.hadoop.io.erasurecode.rawcoder.NativeRSRawErasureCoderFactory;
import org.apache.hadoop.io.erasurecode.rawcoder.NativeXORRawErasureCoderFactory;
import org.apache.hadoop.io.erasurecode.rawcoder.RSRawErasureCoderFactory;
import org.apache.hadoop.io.erasurecode.rawcoder.RawErasureCoderFactory;
import org.apache.hadoop.io.erasurecode.rawcoder.TestRawCoderBase;
import org.apache.hadoop.io.erasurecode.rawcoder.XORRawErasureCoderFactory;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestDecodingValidator
extends TestRawCoderBase {
    private DecodingValidator validator;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({RSRawErasureCoderFactory.class, 6, 3, new int[]{1}, new int[0]}, {RSRawErasureCoderFactory.class, 6, 3, new int[]{3}, new int[]{0}}, {RSRawErasureCoderFactory.class, 6, 3, new int[]{2, 4}, new int[]{1}}, {NativeRSRawErasureCoderFactory.class, 6, 3, new int[]{0}, new int[0]}, {XORRawErasureCoderFactory.class, 10, 1, new int[]{0}, new int[0]}, {NativeXORRawErasureCoderFactory.class, 10, 1, new int[]{0}, new int[0]});
    }

    public TestDecodingValidator(Class<? extends RawErasureCoderFactory> factoryClass, int numDataUnits, int numParityUnits, int[] erasedDataIndexes, int[] erasedParityIndexes) {
        this.encoderFactoryClass = factoryClass;
        this.decoderFactoryClass = factoryClass;
        this.numDataUnits = numDataUnits;
        this.numParityUnits = numParityUnits;
        this.erasedDataIndexes = erasedDataIndexes;
        this.erasedParityIndexes = erasedParityIndexes;
    }

    @Before
    public void setup() {
        if (this.encoderFactoryClass == NativeRSRawErasureCoderFactory.class || this.encoderFactoryClass == NativeXORRawErasureCoderFactory.class) {
            Assume.assumeTrue((boolean)ErasureCodeNative.isNativeCodeLoaded());
        }
        this.setAllowDump(false);
    }

    @Test
    public void testValidate() {
        this.prepare(null, this.numDataUnits, this.numParityUnits, this.erasedDataIndexes, this.erasedParityIndexes);
        this.testValidate(true);
        this.testValidate(false);
    }

    protected void testValidate(boolean usingDirectBuffer) {
        this.usingDirectBuffer = usingDirectBuffer;
        this.prepareCoders(false);
        this.prepareValidator(false);
        this.performTestValidate(this.baseChunkSize);
        this.performTestValidate(this.baseChunkSize - 17);
        this.performTestValidate(this.baseChunkSize + 18);
    }

    protected void prepareValidator(boolean recreate) {
        if (this.validator == null || recreate) {
            this.validator = new DecodingValidator(this.decoder);
        }
    }

    protected void performTestValidate(int chunkSize) {
        this.setChunkSize(chunkSize);
        this.prepareBufferAllocator(false);
        ECChunk[] dataChunks = this.prepareDataChunksForEncoding();
        ECChunk[] parityChunks = this.prepareParityChunksForEncoding();
        ECChunk[] clonedDataChunks = this.cloneChunksWithData(dataChunks);
        try {
            this.encoder.encode(dataChunks, parityChunks);
        }
        catch (Exception e) {
            Assert.fail((String)("Should not get Exception: " + e.getMessage()));
        }
        this.backupAndEraseChunks(clonedDataChunks, parityChunks);
        Object[] inputChunks = this.prepareInputChunksForDecoding(clonedDataChunks, parityChunks);
        this.markChunks((ECChunk[])inputChunks);
        this.ensureOnlyLeastRequiredChunks((ECChunk[])inputChunks);
        ECChunk[] recoveredChunks = this.prepareOutputChunksForDecoding();
        int[] erasedIndexes = this.getErasedIndexesForDecoding();
        try {
            this.decoder.decode((ECChunk[])inputChunks, erasedIndexes, recoveredChunks);
        }
        catch (Exception e) {
            Assert.fail((String)("Should not get Exception: " + e.getMessage()));
        }
        this.restoreChunksFromMark((ECChunk[])inputChunks);
        ECChunk[] clonedInputChunks = this.cloneChunksWithData((ECChunk[])inputChunks);
        ECChunk[] clonedRecoveredChunks = this.cloneChunksWithData(recoveredChunks);
        int[] clonedErasedIndexes = (int[])erasedIndexes.clone();
        try {
            this.validator.validate(clonedInputChunks, clonedErasedIndexes, clonedRecoveredChunks);
        }
        catch (Exception e) {
            Assert.fail((String)("Should not get Exception: " + e.getMessage()));
        }
        this.verifyBufferPositionAtEnd(clonedInputChunks);
        this.verifyChunksEqual(recoveredChunks, clonedRecoveredChunks);
        Assert.assertArrayEquals((String)"Erased indexes should not be changed", (int[])erasedIndexes, (int[])clonedErasedIndexes);
        List validIndexesList = IntStream.of(CoderUtil.getValidIndexes((Object[])inputChunks)).boxed().collect(Collectors.toList());
        List newValidIndexesList = IntStream.of(this.validator.getNewValidIndexes()).boxed().collect(Collectors.toList());
        List erasedIndexesList = IntStream.of(erasedIndexes).boxed().collect(Collectors.toList());
        int newErasedIndex = this.validator.getNewErasedIndex();
        Assert.assertTrue((String)"Valid indexes for validation should contain erased indexes for decoding", (boolean)newValidIndexesList.containsAll(erasedIndexesList));
        Assert.assertTrue((String)"An erased index for validation should be contained in valid indexes for decoding", (boolean)validIndexesList.contains(newErasedIndex));
        Assert.assertFalse((String)"An erased index for validation should not be contained in valid indexes for validation", (boolean)newValidIndexesList.contains(newErasedIndex));
    }

    private void verifyChunksEqual(ECChunk[] chunks1, ECChunk[] chunks2) {
        boolean result = Arrays.deepEquals((Object[])this.toArrays(chunks1), (Object[])this.toArrays(chunks2));
        Assert.assertTrue((String)"Recovered chunks should not be changed", (boolean)result);
    }

    @Test
    public void testValidateWithBadDecoding() throws IOException {
        this.prepare(null, this.numDataUnits, this.numParityUnits, this.erasedDataIndexes, this.erasedParityIndexes);
        this.usingDirectBuffer = true;
        this.prepareCoders(true);
        this.prepareValidator(true);
        this.prepareBufferAllocator(false);
        ECChunk[] dataChunks = this.prepareDataChunksForEncoding();
        ECChunk[] parityChunks = this.prepareParityChunksForEncoding();
        ECChunk[] clonedDataChunks = this.cloneChunksWithData(dataChunks);
        try {
            this.encoder.encode(dataChunks, parityChunks);
        }
        catch (Exception e) {
            Assert.fail((String)("Should not get Exception: " + e.getMessage()));
        }
        this.backupAndEraseChunks(clonedDataChunks, parityChunks);
        ECChunk[] inputChunks = this.prepareInputChunksForDecoding(clonedDataChunks, parityChunks);
        this.markChunks(inputChunks);
        this.ensureOnlyLeastRequiredChunks(inputChunks);
        ECChunk[] recoveredChunks = this.prepareOutputChunksForDecoding();
        int[] erasedIndexes = this.getErasedIndexesForDecoding();
        try {
            this.decoder.decode(inputChunks, erasedIndexes, recoveredChunks);
        }
        catch (Exception e) {
            Assert.fail((String)("Should not get Exception: " + e.getMessage()));
        }
        this.restoreChunksFromMark(inputChunks);
        this.polluteSomeChunk(recoveredChunks);
        try {
            this.validator.validate(inputChunks, erasedIndexes, recoveredChunks);
            Assert.fail((String)"Validation should fail due to bad decoding");
        }
        catch (InvalidDecodingException e) {
            String expected = "Failed to validate decoding";
            GenericTestUtils.assertExceptionContains(expected, e);
        }
    }
}

