/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.compress;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.hadoop.io.compress.BlockCompressorStream;
import org.apache.hadoop.io.compress.BlockDecompressorStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.compress.FakeCompressor;
import org.apache.hadoop.io.compress.FakeDecompressor;
import org.junit.Assert;
import org.junit.Test;

public class TestBlockDecompressorStream {
    private byte[] buf;
    private ByteArrayInputStream bytesIn;
    private ByteArrayOutputStream bytesOut;

    @Test
    public void testRead1() throws IOException {
        this.testRead(0);
    }

    @Test
    public void testRead2() throws IOException {
        this.testRead(4);
    }

    private void testRead(int bufLen) throws IOException {
        this.bytesOut = new ByteArrayOutputStream();
        if (bufLen > 0) {
            this.bytesOut.write(ByteBuffer.allocate(bufLen).putInt(1024).array(), 0, bufLen);
        }
        BlockCompressorStream blockCompressorStream = new BlockCompressorStream((OutputStream)this.bytesOut, (Compressor)new FakeCompressor(), 1024, 0);
        blockCompressorStream.close();
        this.buf = this.bytesOut.toByteArray();
        Assert.assertEquals((String)("empty file compressed output size is not " + (bufLen + 4)), (long)(bufLen + 4), (long)this.buf.length);
        this.bytesIn = new ByteArrayInputStream(this.buf);
        try (BlockDecompressorStream blockDecompressorStream = new BlockDecompressorStream((InputStream)this.bytesIn, (Decompressor)new FakeDecompressor(), 1024);){
            Assert.assertEquals((String)"return value is not -1", (long)-1L, (long)blockDecompressorStream.read());
        }
        catch (IOException e) {
            Assert.fail((String)("unexpected IOException : " + e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadWhenIoExceptionOccure() throws IOException {
        File file = new File("testReadWhenIOException");
        try {
            file.createNewFile();
            FileInputStream io = new FileInputStream(file){

                @Override
                public int read() throws IOException {
                    throw new IOException("File blocks missing");
                }
            };
            try (BlockDecompressorStream blockDecompressorStream = new BlockDecompressorStream((InputStream)io, (Decompressor)new FakeDecompressor(), 1024);){
                int byteRead = blockDecompressorStream.read();
                Assert.fail((String)("Should not return -1 in case of IOException. Byte read " + byteRead));
            }
            catch (IOException e) {
                Assert.assertTrue((boolean)e.getMessage().contains("File blocks missing"));
            }
        }
        finally {
            file.delete();
        }
    }
}

