/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.thirdparty.com.google.common.base.Joiner;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.webapp.dao.QueueConfigInfo;
import org.apache.hadoop.yarn.webapp.dao.SchedConfUpdateInfo;

public final class ConfigurationUpdateAssembler {
    private ConfigurationUpdateAssembler() {
    }

    public static Map<String, String> constructKeyValueConfUpdate(CapacitySchedulerConfiguration proposedConf, SchedConfUpdateInfo mutationInfo) throws IOException {
        HashMap<String, String> confUpdate = new HashMap<String, String>();
        for (String string : mutationInfo.getRemoveQueueInfo()) {
            ConfigurationUpdateAssembler.removeQueue(string, proposedConf, confUpdate);
        }
        for (QueueConfigInfo queueConfigInfo : mutationInfo.getAddQueueInfo()) {
            ConfigurationUpdateAssembler.addQueue(queueConfigInfo, proposedConf, confUpdate);
        }
        for (QueueConfigInfo queueConfigInfo : mutationInfo.getUpdateQueueInfo()) {
            ConfigurationUpdateAssembler.updateQueue(queueConfigInfo, proposedConf, confUpdate);
        }
        for (Map.Entry entry : mutationInfo.getGlobalParams().entrySet()) {
            confUpdate.put((String)entry.getKey(), (String)entry.getValue());
        }
        return confUpdate;
    }

    private static void removeQueue(String queueToRemove, CapacitySchedulerConfiguration proposedConf, Map<String, String> confUpdate) throws IOException {
        if (queueToRemove == null) {
            return;
        }
        if (queueToRemove.lastIndexOf(46) == -1) {
            throw new IOException("Can't remove queue " + queueToRemove);
        }
        String queueName = queueToRemove.substring(queueToRemove.lastIndexOf(46) + 1);
        List<String> siblingQueues = ConfigurationUpdateAssembler.getSiblingQueues(queueToRemove, proposedConf);
        if (!siblingQueues.contains(queueName)) {
            throw new IOException("Queue " + queueToRemove + " not found");
        }
        siblingQueues.remove(queueName);
        String parentQueuePath = queueToRemove.substring(0, queueToRemove.lastIndexOf(46));
        proposedConf.setQueues(parentQueuePath, siblingQueues.toArray(new String[0]));
        String queuesConfig = "yarn.scheduler.capacity." + parentQueuePath + "." + "queues";
        if (siblingQueues.isEmpty()) {
            confUpdate.put(queuesConfig, null);
            String queueOrderingPolicy = "yarn.scheduler.capacity." + parentQueuePath + "." + "ordering-policy";
            proposedConf.unset(queueOrderingPolicy);
            confUpdate.put(queueOrderingPolicy, null);
        } else {
            confUpdate.put(queuesConfig, Joiner.on((char)',').join(siblingQueues));
        }
        for (Map.Entry confRemove : proposedConf.getValByRegex(".*" + queueToRemove + "\\..*").entrySet()) {
            proposedConf.unset((String)confRemove.getKey());
            confUpdate.put((String)confRemove.getKey(), (String)null);
        }
    }

    private static void addQueue(QueueConfigInfo addInfo, CapacitySchedulerConfiguration proposedConf, Map<String, String> confUpdate) throws IOException {
        if (addInfo == null) {
            return;
        }
        String queuePath = addInfo.getQueue();
        String queueName = queuePath.substring(queuePath.lastIndexOf(46) + 1);
        if (queuePath.lastIndexOf(46) == -1) {
            throw new IOException("Can't add invalid queue " + queuePath);
        }
        if (ConfigurationUpdateAssembler.getSiblingQueues(queuePath, proposedConf).contains(queueName)) {
            throw new IOException("Can't add existing queue " + queuePath);
        }
        String parentQueue = queuePath.substring(0, queuePath.lastIndexOf(46));
        String[] siblings = proposedConf.getQueues(parentQueue);
        ArrayList<String> siblingQueues = siblings == null ? new ArrayList<String>() : new ArrayList<String>(Arrays.asList(siblings));
        siblingQueues.add(queuePath.substring(queuePath.lastIndexOf(46) + 1));
        proposedConf.setQueues(parentQueue, siblingQueues.toArray(new String[0]));
        confUpdate.put("yarn.scheduler.capacity." + parentQueue + "." + "queues", Joiner.on((char)',').join(siblingQueues));
        String keyPrefix = "yarn.scheduler.capacity." + queuePath + ".";
        for (Map.Entry kv : addInfo.getParams().entrySet()) {
            String keyValue = (String)kv.getValue();
            if (keyValue == null || keyValue.isEmpty()) {
                proposedConf.unset(keyPrefix + (String)kv.getKey());
                confUpdate.put(keyPrefix + (String)kv.getKey(), null);
                continue;
            }
            proposedConf.set(keyPrefix + (String)kv.getKey(), keyValue);
            confUpdate.put(keyPrefix + (String)kv.getKey(), keyValue);
        }
        String queueOrderingPolicy = "yarn.scheduler.capacity." + parentQueue + "." + "ordering-policy";
        if (siblingQueues.size() == 1) {
            proposedConf.unset(queueOrderingPolicy);
            confUpdate.put(queueOrderingPolicy, null);
        }
    }

    private static void updateQueue(QueueConfigInfo updateInfo, CapacitySchedulerConfiguration proposedConf, Map<String, String> confUpdate) {
        if (updateInfo == null) {
            return;
        }
        String queuePath = updateInfo.getQueue();
        String keyPrefix = "yarn.scheduler.capacity." + queuePath + ".";
        for (Map.Entry kv : updateInfo.getParams().entrySet()) {
            String keyValue = (String)kv.getValue();
            if (keyValue == null || keyValue.isEmpty()) {
                proposedConf.unset(keyPrefix + (String)kv.getKey());
                confUpdate.put(keyPrefix + (String)kv.getKey(), null);
                continue;
            }
            proposedConf.set(keyPrefix + (String)kv.getKey(), keyValue);
            confUpdate.put(keyPrefix + (String)kv.getKey(), keyValue);
        }
    }

    private static List<String> getSiblingQueues(String queuePath, Configuration conf) {
        String parentQueue = queuePath.substring(0, queuePath.lastIndexOf(46));
        String childQueuesKey = "yarn.scheduler.capacity." + parentQueue + "." + "queues";
        return new ArrayList<String>(conf.getTrimmedStringCollection(childQueuesKey));
    }
}

