/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.util.Set;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractCSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractQueueCapacityCalculator;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CalculationContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueCapacityVector;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ResourceCalculationDriver;

public class WeightQueueCapacityCalculator
extends AbstractQueueCapacityCalculator {
    @Override
    public void calculateResourcePrerequisites(ResourceCalculationDriver resourceCalculationDriver) {
        for (CSQueue childQueue : resourceCalculationDriver.getChildQueues()) {
            for (String label : childQueue.getConfiguredNodeLabels()) {
                for (String resourceName : childQueue.getConfiguredCapacityVector(label).getResourceNamesByCapacityType(this.getCapacityType())) {
                    resourceCalculationDriver.incrementWeight(label, resourceName, childQueue.getConfiguredCapacityVector(label).getResource(resourceName).getResourceValue());
                }
            }
        }
    }

    @Override
    public double calculateMinimumResource(ResourceCalculationDriver resourceCalculationDriver, CalculationContext context, String label) {
        String resourceName = context.getResourceName();
        double normalizedWeight = context.getCurrentMinimumCapacityEntry(label).getResourceValue() / resourceCalculationDriver.getSumWeightsByResource(label, resourceName);
        double remainingResource = resourceCalculationDriver.getBatchRemainingResource(label).getValue(resourceName);
        if (normalizedWeight == 1.0) {
            return remainingResource;
        }
        double remainingResourceRatio = resourceCalculationDriver.getRemainingRatioOfResource(label, resourceName);
        double parentAbsoluteCapacity = resourceCalculationDriver.getParentAbsoluteMinCapacity(label, resourceName);
        double queueAbsoluteCapacity = parentAbsoluteCapacity * remainingResourceRatio * normalizedWeight;
        return (double)resourceCalculationDriver.getUpdateContext().getUpdatedClusterResource(label).getResourceValue(resourceName) * queueAbsoluteCapacity;
    }

    @Override
    public double calculateMaximumResource(ResourceCalculationDriver resourceCalculationDriver, CalculationContext context, String label) {
        throw new IllegalStateException("Resource " + context.getCurrentMinimumCapacityEntry(label).getResourceName() + " has WEIGHT maximum capacity type, which is not supported");
    }

    @Override
    public QueueCapacityVector.ResourceUnitCapacityType getCapacityType() {
        return QueueCapacityVector.ResourceUnitCapacityType.WEIGHT;
    }

    @Override
    public void updateCapacitiesAfterCalculation(ResourceCalculationDriver resourceCalculationDriver, CSQueue queue, String label) {
        double sumCapacityPerResource = 0.0;
        Set<String> resourceNames = this.getResourceNames(queue, label);
        for (String resourceName : resourceNames) {
            double sumBranchWeight = resourceCalculationDriver.getSumWeightsByResource(label, resourceName);
            double capacity = queue.getConfiguredCapacityVector(label).getResource(resourceName).getResourceValue() / sumBranchWeight;
            sumCapacityPerResource += capacity;
        }
        queue.getQueueCapacities().setNormalizedWeight(label, (float)(sumCapacityPerResource / (double)resourceNames.size()));
        ((AbstractCSQueue)queue).updateAbsoluteCapacities();
    }
}

