/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.nativetask.handlers;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.mapred.RawKeyValueIterator;
import org.apache.hadoop.mapred.nativetask.DataReceiver;
import org.apache.hadoop.mapred.nativetask.NativeDataSource;
import org.apache.hadoop.mapred.nativetask.buffer.BufferType;
import org.apache.hadoop.mapred.nativetask.buffer.ByteBufferDataReader;
import org.apache.hadoop.mapred.nativetask.buffer.InputBuffer;
import org.apache.hadoop.util.Progress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class BufferPuller
implements RawKeyValueIterator,
DataReceiver {
    private static final Logger LOG = LoggerFactory.getLogger(BufferPuller.class);
    public static final int KV_HEADER_LENGTH = 8;
    byte[] keyBytes = new byte[0];
    byte[] valueBytes = new byte[0];
    private InputBuffer inputBuffer;
    private InputBuffer asideBuffer;
    int remain = 0;
    private ByteBufferDataReader nativeReader;
    DataInputBuffer keyBuffer = new DataInputBuffer();
    DataInputBuffer valueBuffer = new DataInputBuffer();
    private boolean noMoreData = false;
    private NativeDataSource input;
    private boolean closed = false;

    public BufferPuller(NativeDataSource handler) throws IOException {
        this.input = handler;
        this.inputBuffer = handler.getInputBuffer();
        this.nativeReader = new ByteBufferDataReader(null);
        this.asideBuffer = new InputBuffer(BufferType.HEAP_BUFFER, this.inputBuffer.capacity());
    }

    public DataInputBuffer getKey() throws IOException {
        return this.keyBuffer;
    }

    public DataInputBuffer getValue() throws IOException {
        return this.valueBuffer;
    }

    public void reset() {
        this.noMoreData = false;
    }

    public boolean next() throws IOException {
        if (this.closed) {
            return false;
        }
        if (this.noMoreData) {
            return false;
        }
        int asideRemain = this.asideBuffer.remaining();
        int inputRemain = this.inputBuffer.remaining();
        if (asideRemain == 0 && inputRemain == 0) {
            this.input.loadData();
        }
        if (this.asideBuffer.remaining() > 0) {
            return this.nextKeyValue(this.asideBuffer);
        }
        if (this.inputBuffer.remaining() > 0) {
            return this.nextKeyValue(this.inputBuffer);
        }
        this.noMoreData = true;
        return false;
    }

    private boolean nextKeyValue(InputBuffer buffer) throws IOException {
        int valueLength;
        if (this.closed) {
            return false;
        }
        this.nativeReader.reset(buffer);
        int keyLength = this.nativeReader.readInt();
        if (this.keyBytes.length < keyLength) {
            this.keyBytes = new byte[keyLength];
        }
        if (this.valueBytes.length < (valueLength = this.nativeReader.readInt())) {
            this.valueBytes = new byte[valueLength];
        }
        IOUtils.readFully((InputStream)this.nativeReader, (byte[])this.keyBytes, (int)0, (int)keyLength);
        IOUtils.readFully((InputStream)this.nativeReader, (byte[])this.valueBytes, (int)0, (int)valueLength);
        this.keyBuffer.reset(this.keyBytes, keyLength);
        this.valueBuffer.reset(this.valueBytes, valueLength);
        return true;
    }

    @Override
    public boolean receiveData() throws IOException {
        if (this.closed) {
            return false;
        }
        ByteBuffer input = this.inputBuffer.getByteBuffer();
        if (null != this.asideBuffer && this.asideBuffer.length() > 0) {
            if (this.asideBuffer.remaining() > 0) {
                byte[] output = this.asideBuffer.getByteBuffer().array();
                int write = Math.min(this.asideBuffer.remaining(), input.remaining());
                input.get(output, this.asideBuffer.position(), write);
                this.asideBuffer.position(this.asideBuffer.position() + write);
            }
            if (this.asideBuffer.remaining() == 0) {
                this.asideBuffer.position(0);
            }
        }
        if (input.remaining() == 0) {
            return true;
        }
        if (input.remaining() < 8) {
            throw new IOException("incomplete data, input length is: " + input.remaining());
        }
        int position = input.position();
        int keyLength = input.getInt();
        int valueLength = input.getInt();
        input.position(position);
        int kvLength = keyLength + valueLength + 8;
        int remaining = input.remaining();
        if (kvLength > remaining) {
            if (null == this.asideBuffer || this.asideBuffer.capacity() < kvLength) {
                this.asideBuffer = new InputBuffer(BufferType.HEAP_BUFFER, kvLength);
            }
            this.asideBuffer.rewind(0, kvLength);
            input.get(this.asideBuffer.array(), 0, remaining);
            this.asideBuffer.position(remaining);
        }
        return true;
    }

    public Progress getProgress() {
        return null;
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        if (null != this.nativeReader) {
            this.nativeReader.close();
        }
        this.closed = true;
    }
}

