/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store.operation;

import java.math.BigDecimal;
import org.ojalgo.access.Access2D;
import org.ojalgo.matrix.store.operation.FillTransposed;
import org.ojalgo.matrix.store.operation.MatrixOperation;
import org.ojalgo.scalar.ComplexNumber;

public final class FillConjugated
extends MatrixOperation {
    public static final FillConjugated SETUP = new FillConjugated();
    public static int THRESHOLD = 128;

    public static void invoke(BigDecimal[] data, int structure, int firstColumn, int limitColumn, Access2D<?> source) {
        FillTransposed.invoke(data, structure, firstColumn, limitColumn, source);
    }

    public static void invoke(ComplexNumber[] data, int structure, int firstColumn, int limitColumn, Access2D<?> source) {
        int tmpIndex = structure * firstColumn;
        for (int j = firstColumn; j < limitColumn; ++j) {
            for (int i = 0; i < structure; ++i) {
                data[tmpIndex++] = ComplexNumber.valueOf(source.get(j, i)).conjugate();
            }
        }
    }

    public static void invoke(double[] data, int structure, int firstColumn, int limitColumn, Access2D<?> source) {
        FillTransposed.invoke(data, structure, firstColumn, limitColumn, source);
    }

    private FillConjugated() {
    }

    @Override
    public int threshold() {
        return THRESHOLD;
    }
}

