/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.FsDatasetImplTestUtilsFactory;
import org.apache.hadoop.hdfs.server.datanode.Replica;
import org.apache.hadoop.hdfs.server.datanode.ReplicaNotFoundException;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetFactory;
import org.apache.hadoop.util.Preconditions;
import org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public interface FsDatasetTestUtils {
    public MaterializedReplica getMaterializedReplica(ExtendedBlock var1) throws ReplicaNotFoundException;

    public Replica createFinalizedReplica(ExtendedBlock var1) throws IOException;

    public Replica createFinalizedReplica(FsVolumeSpi var1, ExtendedBlock var2) throws IOException;

    public Replica createReplicaInPipeline(ExtendedBlock var1) throws IOException;

    public Replica createReplicaInPipeline(FsVolumeSpi var1, ExtendedBlock var2) throws IOException;

    public Replica createRBW(ExtendedBlock var1) throws IOException;

    public Replica createRBW(FsVolumeSpi var1, ExtendedBlock var2) throws IOException;

    public Replica createReplicaWaitingToBeRecovered(ExtendedBlock var1) throws IOException;

    public Replica createReplicaWaitingToBeRecovered(FsVolumeSpi var1, ExtendedBlock var2) throws IOException;

    public Replica createReplicaUnderRecovery(ExtendedBlock var1, long var2) throws IOException;

    public void checkStoredReplica(Replica var1) throws IOException;

    public void injectCorruptReplica(ExtendedBlock var1) throws IOException;

    public Replica fetchReplica(ExtendedBlock var1);

    public int getDefaultNumOfDataDirs();

    public long getRawCapacity() throws IOException;

    public long getStoredDataLength(ExtendedBlock var1) throws IOException;

    public long getStoredGenerationStamp(ExtendedBlock var1) throws IOException;

    public void changeStoredGenerationStamp(ExtendedBlock var1, long var2) throws IOException;

    public Iterator<Replica> getStoredReplicas(String var1) throws IOException;

    public long getPendingAsyncDeletions();

    public void verifyBlockPoolExists(String var1) throws IOException;

    public void verifyBlockPoolMissing(String var1) throws IOException;

    public static interface MaterializedReplica {
        public void corruptData() throws IOException;

        public void corruptData(byte[] var1) throws IOException;

        public void truncateData(long var1) throws IOException;

        public void deleteData() throws IOException;

        public void corruptMeta() throws IOException;

        public void deleteMeta() throws IOException;

        public void truncateMeta(long var1) throws IOException;

        public void makeUnreachable() throws IOException;
    }

    public static abstract class Factory<D extends FsDatasetTestUtils> {
        public static Factory<?> getFactory(Configuration conf) {
            String className = conf.get("dfs.datanode.fsdataset.factory", FsDatasetFactory.class.getName());
            Preconditions.checkState((boolean)className.contains("Factory"));
            className = className.replaceFirst("(\\$)?Factory$", "TestUtilsFactory");
            Class clazz = conf.getClass(className, FsDatasetImplTestUtilsFactory.class, Factory.class);
            return (Factory)ReflectionUtils.newInstance((Class)clazz, (Configuration)conf);
        }

        public abstract D newInstance(DataNode var1);

        public boolean isSimulated() {
            return false;
        }

        public abstract int getDefaultNumOfDataDirs();
    }
}

