/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key.kms.server;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class KMSConfiguration {
    static final Logger LOG = LoggerFactory.getLogger(KMSConfiguration.class);
    public static final String KMS_CONFIG_DIR = "kms.config.dir";
    public static final String KMS_DEFAULT_XML = "kms-default.xml";
    public static final String KMS_SITE_XML = "kms-site.xml";
    public static final String KMS_ACLS_XML = "kms-acls.xml";
    public static final String CONFIG_PREFIX = "hadoop.kms.";
    public static final String KEY_ACL_PREFIX = "key.acl.";
    public static final String KEY_ACL_PREFIX_REGEX = "^key\\.acl\\..+";
    public static final String DEFAULT_KEY_ACL_PREFIX = "default.key.acl.";
    public static final String WHITELIST_KEY_ACL_PREFIX = "whitelist.key.acl.";
    public static final String HTTP_PORT_KEY = "hadoop.kms.http.port";
    public static final int HTTP_PORT_DEFAULT = 9600;
    public static final String HTTP_HOST_KEY = "hadoop.kms.http.host";
    public static final String HTTP_HOST_DEFAULT = "0.0.0.0";
    public static final String HTTP_ADMINS_KEY = "hadoop.kms.http.administrators";
    public static final String SSL_ENABLED_KEY = "hadoop.kms.ssl.enabled";
    public static final boolean SSL_ENABLED_DEFAULT = false;
    public static final String KEY_PROVIDER_URI = "hadoop.kms.key.provider.uri";
    public static final String KEY_CACHE_ENABLE = "hadoop.kms.cache.enable";
    public static final String KEY_CACHE_TIMEOUT_KEY = "hadoop.kms.cache.timeout.ms";
    public static final String CURR_KEY_CACHE_TIMEOUT_KEY = "hadoop.kms.current.key.cache.timeout.ms";
    public static final String KMS_AUDIT_AGGREGATION_WINDOW = "hadoop.kms.audit.aggregation.window.ms";
    public static final String METRICS_PROCESS_NAME_KEY = "hadoop.kms.metrics.process.name";
    public static final String METRICS_PROCESS_NAME_DEFAULT = "KMS";
    public static final String METRICS_SESSION_ID_KEY = "hadoop.kms.metrics.session.id";
    public static final String KMS_AUDIT_LOGGER_KEY = "hadoop.kms.audit.logger";
    public static final boolean KEY_CACHE_ENABLE_DEFAULT = true;
    public static final long KEY_CACHE_TIMEOUT_DEFAULT = 600000L;
    public static final long CURR_KEY_CACHE_TIMEOUT_DEFAULT = 30000L;
    public static final long KMS_AUDIT_AGGREGATION_WINDOW_DEFAULT = 10000L;
    public static final String KEY_AUTHORIZATION_ENABLE = "hadoop.kms.key.authorization.enable";
    public static final boolean KEY_AUTHORIZATION_ENABLE_DEFAULT = true;

    static Configuration getConfiguration(boolean loadHadoopDefaults, String ... resources) {
        Configuration conf = new Configuration(loadHadoopDefaults);
        String confDir = System.getProperty(KMS_CONFIG_DIR);
        if (confDir != null) {
            try {
                Path confPath = new Path(confDir);
                if (!confPath.isUriPathAbsolute()) {
                    throw new RuntimeException("System property 'kms.config.dir' must be an absolute path: " + confDir);
                }
                for (String resource : resources) {
                    conf.addResource(new URL("file://" + new Path(confDir, resource).toUri()));
                }
            }
            catch (MalformedURLException ex) {
                throw new RuntimeException(ex);
            }
        } else {
            for (String resource : resources) {
                conf.addResource(resource);
            }
        }
        return conf;
    }

    public static Configuration getKMSConf() {
        return KMSConfiguration.getConfiguration(true, "core-site.xml", KMS_SITE_XML);
    }

    public static Configuration getACLsConf() {
        return KMSConfiguration.getConfiguration(false, KMS_ACLS_XML);
    }

    public static boolean isACLsFileNewer(long time) {
        boolean newer = false;
        String confDir = System.getProperty(KMS_CONFIG_DIR);
        if (confDir != null) {
            Path confPath = new Path(confDir);
            if (!confPath.isUriPathAbsolute()) {
                throw new RuntimeException("System property 'kms.config.dir' must be an absolute path: " + confDir);
            }
            File f = new File(confDir, KMS_ACLS_XML);
            LOG.trace("Checking file {}, modification time is {}, last reload time is {}", new Object[]{f.getPath(), f.lastModified(), time});
            newer = f.lastModified() - time > 100L;
        }
        return newer;
    }

    public static void validateSystemProps() {
        if (System.getProperty(KMS_CONFIG_DIR) == null) {
            String errorMsg = "System property 'kms.config.dir' not defined";
            System.err.println("Aborting KMSWebServer because " + errorMsg);
            throw new RuntimeException(errorMsg);
        }
        if (System.getProperty("log4j.configuration") == null) {
            String errorMsg = "System property 'log4j.configuration' not defined";
            System.err.println("Aborting KMSWebServer because " + errorMsg);
            throw new RuntimeException(errorMsg);
        }
    }

    static {
        Configuration.addDefaultResource((String)KMS_DEFAULT_XML);
        Configuration.addDefaultResource((String)KMS_SITE_XML);
    }
}

