/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

public class QueueUpdateWarning {
    private final String queue;
    private final QueueUpdateWarningType warningType;
    private String info = "";

    public QueueUpdateWarning(QueueUpdateWarningType queueUpdateWarningType, String queue) {
        this.warningType = queueUpdateWarningType;
        this.queue = queue;
    }

    public QueueUpdateWarning withInfo(String info) {
        this.info = info;
        return this;
    }

    public String getQueue() {
        return this.queue;
    }

    public QueueUpdateWarningType getWarningType() {
        return this.warningType;
    }

    public String toString() {
        return String.format(this.warningType.getTemplate(), this.queue, this.info);
    }

    public static enum QueueUpdateWarningType {
        BRANCH_UNDERUTILIZED("Remaining resource found in branch under parent queue '%s'. %s"),
        QUEUE_OVERUTILIZED("Queue '%s' is configured to use more resources than what is available under its parent. %s"),
        QUEUE_ZERO_RESOURCE("Queue '%s' is assigned zero resource. %s"),
        BRANCH_DOWNSCALED("Child queues with absolute configured capacity under parent queue '%s' are downscaled due to insufficient cluster resource. %s"),
        QUEUE_EXCEEDS_MAX_RESOURCE("Queue '%s' exceeds its maximum available resources. %s"),
        QUEUE_MAX_RESOURCE_EXCEEDS_PARENT("Maximum resources of queue '%s' are greater than its parent's. %s");

        private final String template;

        private QueueUpdateWarningType(String template) {
            this.template = template;
        }

        public QueueUpdateWarning ofQueue(String queue) {
            return new QueueUpdateWarning(this, queue);
        }

        public String getTemplate() {
            return this.template;
        }
    }
}

