/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.ehcache.shadow.org.terracotta.statistics.derived;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.apache.hadoop.shaded.org.ehcache.shadow.org.terracotta.statistics.AbstractSourceStatistic;
import org.apache.hadoop.shaded.org.ehcache.shadow.org.terracotta.statistics.observer.ChainedEventObserver;
import org.apache.hadoop.shaded.org.ehcache.shadow.org.terracotta.statistics.observer.ChainedOperationObserver;

public class OperationResultFilter<T extends Enum<T>>
extends AbstractSourceStatistic<ChainedEventObserver>
implements ChainedOperationObserver<T> {
    protected final Set<T> targets;

    public OperationResultFilter(Set<T> targets, ChainedEventObserver ... observers) {
        this.targets = EnumSet.copyOf(targets);
        for (ChainedEventObserver observer : observers) {
            this.addDerivedStatistic(observer);
        }
    }

    @Override
    public void begin(long time) {
    }

    @Override
    public void end(long time, long latency, T result) {
        if (!this.derivedStatistics.isEmpty() && this.targets.contains(result)) {
            for (ChainedEventObserver derived : this.derivedStatistics) {
                derived.event(time, latency);
            }
        }
    }

    public Set<T> getTargets() {
        return Collections.unmodifiableSet(this.targets);
    }
}

