/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.random;

import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.lang3.SystemUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.random.OsSecureRandom;
import org.junit.Assume;
import org.junit.Test;

public class TestOsSecureRandom {
    private static OsSecureRandom getOsSecureRandom() throws IOException {
        Assume.assumeTrue((boolean)SystemUtils.IS_OS_LINUX);
        OsSecureRandom random = new OsSecureRandom();
        random.setConf(new Configuration());
        return random;
    }

    @Test(timeout=120000L)
    public void testRandomBytes() throws Exception {
        OsSecureRandom random = TestOsSecureRandom.getOsSecureRandom();
        this.checkRandomBytes(random, 16);
        this.checkRandomBytes(random, 32);
        this.checkRandomBytes(random, 128);
        this.checkRandomBytes(random, 256);
        random.close();
    }

    private void checkRandomBytes(OsSecureRandom random, int len) {
        byte[] bytes = new byte[len];
        byte[] bytes1 = new byte[len];
        random.nextBytes(bytes);
        random.nextBytes(bytes1);
        while (Arrays.equals(bytes, bytes1)) {
            random.nextBytes(bytes1);
        }
    }

    @Test(timeout=120000L)
    public void testRandomInt() throws Exception {
        OsSecureRandom random = TestOsSecureRandom.getOsSecureRandom();
        int rand1 = random.nextInt();
        int rand2 = random.nextInt();
        while (rand1 == rand2) {
            rand2 = random.nextInt();
        }
        random.close();
    }

    @Test(timeout=120000L)
    public void testRandomLong() throws Exception {
        OsSecureRandom random = TestOsSecureRandom.getOsSecureRandom();
        long rand1 = random.nextLong();
        long rand2 = random.nextLong();
        while (rand1 == rand2) {
            rand2 = random.nextLong();
        }
        random.close();
    }

    @Test(timeout=120000L)
    public void testRandomFloat() throws Exception {
        OsSecureRandom random = TestOsSecureRandom.getOsSecureRandom();
        float rand1 = random.nextFloat();
        float rand2 = random.nextFloat();
        while (rand1 == rand2) {
            rand2 = random.nextFloat();
        }
        random.close();
    }

    @Test(timeout=120000L)
    public void testRandomDouble() throws Exception {
        OsSecureRandom random = TestOsSecureRandom.getOsSecureRandom();
        double rand1 = random.nextDouble();
        double rand2 = random.nextDouble();
        while (rand1 == rand2) {
            rand2 = random.nextDouble();
        }
        random.close();
    }

    @Test(timeout=120000L)
    public void testRefillReservoir() throws Exception {
        OsSecureRandom random = TestOsSecureRandom.getOsSecureRandom();
        for (int i = 0; i < 8196; ++i) {
            random.nextLong();
        }
        random.close();
    }
}

