/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.random;

import java.util.Random;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.random.Distribution;
import org.ojalgo.type.Alternator;

public abstract class RandomNumber
extends Number
implements Distribution,
NullaryFunction<Double> {
    private static final Random SEED = new Random();
    private static final long serialVersionUID = -5871398825698010936L;
    private final Alternator<Random> myAlternator = RandomNumber.makeRandomAlternator();

    static Alternator<Random> makeRandomAlternator() {
        return new Alternator<Random>(new Random(SEED.nextLong()), new Random(SEED.nextLong()));
    }

    protected RandomNumber() {
    }

    @Override
    public final double doubleValue() {
        return this.generate();
    }

    @Override
    public final float floatValue() {
        return (float)this.generate();
    }

    @Override
    public double getStandardDeviation() {
        return PrimitiveFunction.SQRT.invoke(this.getVariance());
    }

    @Override
    public double getVariance() {
        double tmpStandardDeviation = this.getStandardDeviation();
        return tmpStandardDeviation * tmpStandardDeviation;
    }

    @Override
    public final int intValue() {
        return (int)this.generate();
    }

    @Override
    public final Double invoke() {
        return this.generate();
    }

    @Override
    public final long longValue() {
        return (long)this.generate();
    }

    public String toString() {
        return this.getExpected() + "\u00b1" + this.getStandardDeviation();
    }

    protected void checkProbabilty(double aProbabilty) {
        if (aProbabilty < PrimitiveMath.ZERO || PrimitiveMath.ONE < aProbabilty) {
            throw new IllegalArgumentException("Probabilty must be [0,1]");
        }
    }

    protected abstract double generate();

    protected final Random random() {
        return this.myAlternator.get();
    }
}

