/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function.multiary;

import org.ojalgo.access.Access1D;
import org.ojalgo.function.multiary.FirstOrderApproximation;
import org.ojalgo.function.multiary.MultiaryFunction;
import org.ojalgo.function.multiary.SecondOrderApproximation;
import org.ojalgo.matrix.store.PhysicalStore;

abstract class ApproximateFunction<N extends Number>
implements MultiaryFunction<N>,
MultiaryFunction.TwiceDifferentiable<N> {
    private final Access1D<N> myPoint;

    protected ApproximateFunction(MultiaryFunction.TwiceDifferentiable<N> function, Access1D<N> point) {
        this.myPoint = point;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApproximateFunction)) {
            return false;
        }
        ApproximateFunction other = (ApproximateFunction)obj;
        return !(this.myPoint == null ? other.myPoint != null : !this.myPoint.equals(other.myPoint));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myPoint == null ? 0 : this.myPoint.hashCode());
        return result;
    }

    @Override
    public final FirstOrderApproximation<N> toFirstOrderApproximation(Access1D<N> arg) {
        return new FirstOrderApproximation<N>(this, arg);
    }

    @Override
    public final SecondOrderApproximation<N> toSecondOrderApproximation(Access1D<N> arg) {
        return new SecondOrderApproximation<N>(this, arg);
    }

    protected abstract PhysicalStore.Factory<N, ?> factory();

    protected PhysicalStore<N> shift(Access1D<?> arg) {
        PhysicalStore retVal = (PhysicalStore)this.factory().columns(arg);
        retVal.modifyMatching(this.factory().function().subtract(), this.myPoint);
        return retVal;
    }
}

