/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class RegionInfoDisplay {
    public static final String DISPLAY_KEYS_KEY = "hbase.display.keys";
    public static final byte[] HIDDEN_END_KEY = Bytes.toBytes((String)"hidden-end-key");
    public static final byte[] HIDDEN_START_KEY = Bytes.toBytes((String)"hidden-start-key");

    public static String getDescriptiveNameFromRegionStateForDisplay(RegionState state, Configuration conf) {
        if (conf.getBoolean(DISPLAY_KEYS_KEY, true)) {
            return state.toDescriptiveString();
        }
        String descriptiveStringFromState = state.toDescriptiveString();
        int idx = descriptiveStringFromState.lastIndexOf(" state=");
        String regionName = RegionInfoDisplay.getRegionNameAsStringForDisplay(RegionInfoBuilder.newBuilder(state.getRegion()).build(), conf);
        return regionName + descriptiveStringFromState.substring(idx);
    }

    public static byte[] getEndKeyForDisplay(RegionInfo ri, Configuration conf) {
        boolean displayKey = conf.getBoolean(DISPLAY_KEYS_KEY, true);
        if (displayKey) {
            return ri.getEndKey();
        }
        return HIDDEN_END_KEY;
    }

    public static byte[] getStartKeyForDisplay(RegionInfo ri, Configuration conf) {
        boolean displayKey = conf.getBoolean(DISPLAY_KEYS_KEY, true);
        if (displayKey) {
            return ri.getStartKey();
        }
        return HIDDEN_START_KEY;
    }

    public static String getRegionNameAsStringForDisplay(RegionInfo ri, Configuration conf) {
        return Bytes.toStringBinary((byte[])RegionInfoDisplay.getRegionNameForDisplay(ri, conf));
    }

    public static byte[] getRegionNameForDisplay(RegionInfo ri, Configuration conf) {
        boolean displayKey = conf.getBoolean(DISPLAY_KEYS_KEY, true);
        if (displayKey || ri.getTable().equals((Object)TableName.META_TABLE_NAME)) {
            return ri.getRegionName();
        }
        try {
            byte[][] regionNameParts = RegionInfo.parseRegionName(ri.getRegionName());
            regionNameParts[1] = HIDDEN_START_KEY;
            int len = 0;
            for (byte[] b : regionNameParts) {
                len += b.length;
            }
            byte[] encodedRegionName = Bytes.toBytes((String)RegionInfo.encodeRegionName(ri.getRegionName()));
            byte[] modifiedName = new byte[(len += encodedRegionName.length) + regionNameParts.length + 1];
            int lengthSoFar = 0;
            int loopCount = 0;
            for (byte[] b : regionNameParts) {
                System.arraycopy(b, 0, modifiedName, lengthSoFar, b.length);
                lengthSoFar += b.length;
                modifiedName[lengthSoFar++] = loopCount++ == 2 ? 95 : 44;
            }
            modifiedName[lengthSoFar - 1] = 46;
            System.arraycopy(encodedRegionName, 0, modifiedName, lengthSoFar, encodedRegionName.length);
            modifiedName[lengthSoFar += encodedRegionName.length] = 46;
            return modifiedName;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

