/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.server.namenode.ha.AbstractNNFailoverProxyProvider;
import org.apache.hadoop.hdfs.server.namenode.ha.ClientHAProxyFactory;
import org.apache.hadoop.hdfs.server.namenode.ha.HAProxyFactory;
import org.apache.hadoop.hdfs.server.namenode.ha.NameNodeHAProxyFactory;
import org.apache.hadoop.hdfs.server.namenode.ha.ObserverReadProxyProvider;
import org.apache.hadoop.ipc.ObserverRetryOnActiveException;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.StandbyException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.thirdparty.com.google.common.base.Joiner;
import org.apache.hadoop.tools.GetUserMappingsProtocol;
import org.apache.hadoop.util.StopWatch;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public class TestObserverReadProxyProvider {
    private static final long SLOW_RESPONSE_SLEEP_TIME = TimeUnit.SECONDS.toMillis(5L);
    private static final long NAMENODE_HA_STATE_PROBE_TIMEOUT_SHORT = TimeUnit.SECONDS.toMillis(2L);
    private static final long NAMENODE_HA_STATE_PROBE_TIMEOUT_LONG = TimeUnit.SECONDS.toMillis(25L);
    private final GenericTestUtils.LogCapturer proxyLog = GenericTestUtils.LogCapturer.captureLogs((Logger)ObserverReadProxyProvider.LOG);
    private static final LocatedBlock[] EMPTY_BLOCKS = new LocatedBlock[0];
    private String ns;
    private URI nnURI;
    private ObserverReadProxyProvider<ClientProtocol> proxyProvider;
    private NameNodeAnswer[] namenodeAnswers;
    private String[] namenodeAddrs;

    @BeforeClass
    public static void setLogLevel() {
        GenericTestUtils.setLogLevel((Logger)ObserverReadProxyProvider.LOG, (Level)Level.DEBUG);
    }

    @Before
    public void setup() throws Exception {
        this.ns = "testcluster";
        this.nnURI = URI.create("hdfs://" + this.ns);
    }

    private void setupProxyProvider(int namenodeCount) throws Exception {
        this.setupProxyProvider(namenodeCount, new Configuration());
    }

    private void setupProxyProvider(int namenodeCount, long nnHAStateProbeTimeout) throws Exception {
        Configuration conf = new Configuration();
        conf.setLong("dfs.client.failover.namenode.ha-state.probe.timeout", nnHAStateProbeTimeout);
        this.setupProxyProvider(namenodeCount, conf);
    }

    private void setupProxyProvider(int namenodeCount, Configuration conf) throws Exception {
        Object[] namenodeIDs = new String[namenodeCount];
        this.namenodeAddrs = new String[namenodeCount];
        this.namenodeAnswers = new NameNodeAnswer[namenodeCount];
        ClientProtocol[] proxies = new ClientProtocol[namenodeCount];
        final HashMap<String, ClientProtocol> proxyMap = new HashMap<String, ClientProtocol>();
        for (int i = 0; i < namenodeCount; ++i) {
            namenodeIDs[i] = "nn" + i;
            this.namenodeAddrs[i] = "namenode" + i + ".test:8020";
            conf.set("dfs.namenode.rpc-address." + this.ns + "." + (String)namenodeIDs[i], this.namenodeAddrs[i]);
            this.namenodeAnswers[i] = new NameNodeAnswer();
            proxies[i] = (ClientProtocol)Mockito.mock(ClientProtocol.class);
            TestObserverReadProxyProvider.doWrite((ClientProtocol)Mockito.doAnswer((Answer)this.namenodeAnswers[i].clientAnswer).when((Object)proxies[i]));
            TestObserverReadProxyProvider.doRead((ClientProtocol)Mockito.doAnswer((Answer)this.namenodeAnswers[i].clientAnswer).when((Object)proxies[i]));
            ((ClientProtocol)Mockito.doAnswer((Answer)this.namenodeAnswers[i].clientAnswer).when((Object)proxies[i])).getHAServiceState();
            proxyMap.put(this.namenodeAddrs[i], proxies[i]);
        }
        conf.set("dfs.ha.namenodes." + this.ns, Joiner.on((String)",").join(namenodeIDs));
        conf.set("dfs.nameservices", this.ns);
        conf.setTimeDuration("dfs.client.failover.observer.probe.retry.period", 0L, TimeUnit.MILLISECONDS);
        conf.setBoolean("dfs.client.failover.random.order", false);
        this.proxyProvider = new ObserverReadProxyProvider<ClientProtocol>(conf, this.nnURI, ClientProtocol.class, (HAProxyFactory)new ClientHAProxyFactory<ClientProtocol>(){

            public ClientProtocol createProxy(Configuration config, InetSocketAddress nnAddr, Class<ClientProtocol> xface, UserGroupInformation ugi, boolean withRetries, AtomicBoolean fallbackToSimpleAuth) {
                return (ClientProtocol)proxyMap.get(nnAddr.toString());
            }
        }){

            protected List<AbstractNNFailoverProxyProvider.NNProxyInfo<ClientProtocol>> getProxyAddresses(URI uri, String addressKey) {
                List nnProxies = super.getProxyAddresses(uri, addressKey);
                return nnProxies;
            }
        };
        this.proxyProvider.setObserverReadEnabled(true);
    }

    @Test
    public void testWithNonClientProxy() throws Exception {
        this.setupProxyProvider(2);
        String fakeUser = "fakeUser";
        Object[] fakeGroups = new String[]{"fakeGroup"};
        NameNodeHAProxyFactory<GetUserMappingsProtocol> proxyFactory = new NameNodeHAProxyFactory<GetUserMappingsProtocol>((String[])fakeGroups){
            final /* synthetic */ String[] val$fakeGroups;
            {
                this.val$fakeGroups = stringArray;
            }

            public GetUserMappingsProtocol createProxy(Configuration config, InetSocketAddress addr, Class<GetUserMappingsProtocol> xface, UserGroupInformation ugi, boolean withRetries, AtomicBoolean fallbackToSimpleAuth) throws IOException {
                GetUserMappingsProtocol proxy = (GetUserMappingsProtocol)Mockito.mock(GetUserMappingsProtocol.class);
                Mockito.when((Object)proxy.getGroupsForUser("fakeUser")).thenReturn((Object)this.val$fakeGroups);
                return proxy;
            }
        };
        ObserverReadProxyProvider userProxyProvider = new ObserverReadProxyProvider(this.proxyProvider.conf, this.nnURI, GetUserMappingsProtocol.class, (HAProxyFactory)proxyFactory);
        Assert.assertArrayEquals((Object[])fakeGroups, (Object[])((GetUserMappingsProtocol)userProxyProvider.getProxy().proxy).getGroupsForUser("fakeUser"));
    }

    @Test
    public void testReadOperationOnObserver() throws Exception {
        this.setupProxyProvider(3);
        this.namenodeAnswers[0].setActiveState();
        this.namenodeAnswers[2].setObserverState();
        this.doRead();
        this.assertHandledBy(2);
    }

    @Test
    public void testWriteOperationOnActive() throws Exception {
        this.setupProxyProvider(3);
        this.namenodeAnswers[0].setActiveState();
        this.namenodeAnswers[2].setObserverState();
        this.doWrite();
        this.assertHandledBy(0);
    }

    @Test
    public void testUnreachableObserverWithNoBackup() throws Exception {
        this.setupProxyProvider(2);
        this.namenodeAnswers[0].setActiveState();
        this.namenodeAnswers[1].setObserverState();
        this.namenodeAnswers[1].setUnreachable(true);
        this.doRead();
        this.assertHandledBy(0);
    }

    @Test
    public void testUnreachableObserverWithMultiple() throws Exception {
        this.setupProxyProvider(4);
        this.namenodeAnswers[0].setActiveState();
        this.namenodeAnswers[2].setObserverState();
        this.namenodeAnswers[3].setObserverState();
        this.doRead();
        this.assertHandledBy(2);
        this.namenodeAnswers[2].setUnreachable(true);
        this.doRead();
        this.assertHandledBy(3);
        this.namenodeAnswers[2].setUnreachable(false);
        this.doRead();
        this.assertHandledBy(3);
        this.namenodeAnswers[3].setUnreachable(true);
        this.doRead();
        this.assertHandledBy(2);
        this.namenodeAnswers[2].setUnreachable(true);
        this.doRead();
        this.assertHandledBy(0);
    }

    @Test
    public void testObserverToActive() throws Exception {
        this.setupProxyProvider(3);
        this.namenodeAnswers[0].setActiveState();
        this.namenodeAnswers[1].setObserverState();
        this.namenodeAnswers[2].setObserverState();
        this.doWrite();
        this.assertHandledBy(0);
        this.namenodeAnswers[0].setStandbyState();
        this.namenodeAnswers[1].setActiveState();
        try {
            this.doWrite();
            Assert.fail((String)"Write should fail; failover required");
        }
        catch (RemoteException re) {
            Assert.assertEquals((Object)re.getClassName(), (Object)StandbyException.class.getCanonicalName());
        }
        this.proxyProvider.performFailover(this.proxyProvider.getProxy().proxy);
        this.doWrite();
        this.assertHandledBy(1);
        this.doRead();
        this.assertHandledBy(2);
        this.namenodeAnswers[0].setActiveState();
        this.namenodeAnswers[1].setObserverState();
        this.namenodeAnswers[2].setUnreachable(true);
        for (int i = 0; i < 2; ++i) {
            try {
                this.doWrite();
                Assert.fail((String)"Should have failed");
                continue;
            }
            catch (IOException ioe) {
                this.proxyProvider.performFailover(this.proxyProvider.getProxy().proxy);
            }
        }
        this.doWrite();
        this.assertHandledBy(0);
        this.doRead();
        this.assertHandledBy(1);
    }

    @Test
    public void testObserverToStandby() throws Exception {
        this.setupProxyProvider(3);
        this.namenodeAnswers[0].setActiveState();
        this.namenodeAnswers[1].setObserverState();
        this.namenodeAnswers[2].setObserverState();
        this.doRead();
        this.assertHandledBy(1);
        this.namenodeAnswers[1].setStandbyState();
        this.doRead();
        this.assertHandledBy(2);
        this.namenodeAnswers[2].setStandbyState();
        this.doRead();
        this.assertHandledBy(0);
        this.namenodeAnswers[1].setObserverState();
        this.doRead();
        this.assertHandledBy(1);
    }

    @Test
    public void testSingleObserverToStandby() throws Exception {
        this.setupProxyProvider(2);
        this.namenodeAnswers[0].setActiveState();
        this.namenodeAnswers[1].setObserverState();
        this.doRead();
        this.assertHandledBy(1);
        this.namenodeAnswers[1].setStandbyState();
        this.doRead();
        this.assertHandledBy(0);
        this.namenodeAnswers[1].setObserverState();
        this.doRead();
        this.doRead();
        this.assertHandledBy(1);
    }

    @Test
    public void testObserverRetriableException() throws Exception {
        this.setupProxyProvider(3);
        this.namenodeAnswers[0].setActiveState();
        this.namenodeAnswers[1].setObserverState();
        this.namenodeAnswers[2].setObserverState();
        this.namenodeAnswers[1].setRetryActive(true);
        this.doRead();
        this.assertHandledBy(0);
        this.namenodeAnswers[1].setRetryActive(false);
        this.doRead();
        this.assertHandledBy(1);
    }

    @Test
    public void testGetHAServiceStateWithTimeout() throws Exception {
        this.proxyLog.clearOutput();
        this.setupProxyProvider(1, NAMENODE_HA_STATE_PROBE_TIMEOUT_SHORT);
        HAServiceProtocol.HAServiceState state = HAServiceProtocol.HAServiceState.STANDBY;
        AbstractNNFailoverProxyProvider.NNProxyInfo dummyNNProxyInfo = (AbstractNNFailoverProxyProvider.NNProxyInfo)Mockito.mock(AbstractNNFailoverProxyProvider.NNProxyInfo.class);
        Future task = (Future)Mockito.mock(Future.class);
        Mockito.when(task.get(ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any(TimeUnit.class)))).thenReturn((Object)state);
        HAServiceProtocol.HAServiceState state2 = this.proxyProvider.getHAServiceStateWithTimeout(dummyNNProxyInfo, task);
        Assert.assertEquals((Object)state, (Object)state2);
        ((Future)Mockito.verify((Object)task)).get(ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any(TimeUnit.class)));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{task});
        Assert.assertEquals((long)1L, (long)StringUtils.countMatches((CharSequence)this.proxyLog.getOutput(), (CharSequence)("HA State for " + dummyNNProxyInfo.proxyInfo + " is " + state)));
        this.proxyLog.clearOutput();
    }

    @Test
    public void testTimeoutExceptionGetHAServiceStateWithTimeout() throws Exception {
        this.proxyLog.clearOutput();
        this.setupProxyProvider(1, NAMENODE_HA_STATE_PROBE_TIMEOUT_SHORT);
        AbstractNNFailoverProxyProvider.NNProxyInfo dummyNNProxyInfo = (AbstractNNFailoverProxyProvider.NNProxyInfo)Mockito.mock(AbstractNNFailoverProxyProvider.NNProxyInfo.class);
        Future task = (Future)Mockito.mock(Future.class);
        TimeoutException e = new TimeoutException("Timeout");
        Mockito.when(task.get(ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any(TimeUnit.class)))).thenThrow(new Throwable[]{e});
        HAServiceProtocol.HAServiceState state = this.proxyProvider.getHAServiceStateWithTimeout(dummyNNProxyInfo, task);
        Assert.assertNull((Object)state);
        ((Future)Mockito.verify((Object)task)).get(ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any(TimeUnit.class)));
        ((Future)Mockito.verify((Object)task)).cancel(true);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{task});
        Assert.assertEquals((long)1L, (long)StringUtils.countMatches((CharSequence)this.proxyLog.getOutput(), (CharSequence)("Cancel NN probe task due to timeout for " + dummyNNProxyInfo.proxyInfo)));
        this.proxyLog.clearOutput();
    }

    @Test
    public void testInterruptedExceptionGetHAServiceStateWithTimeout() throws Exception {
        this.proxyLog.clearOutput();
        this.setupProxyProvider(1, NAMENODE_HA_STATE_PROBE_TIMEOUT_SHORT);
        AbstractNNFailoverProxyProvider.NNProxyInfo dummyNNProxyInfo = (AbstractNNFailoverProxyProvider.NNProxyInfo)Mockito.mock(AbstractNNFailoverProxyProvider.NNProxyInfo.class);
        Future task = (Future)Mockito.mock(Future.class);
        InterruptedException e = new InterruptedException("Interrupted");
        Mockito.when(task.get(ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any(TimeUnit.class)))).thenThrow(new Throwable[]{e});
        HAServiceProtocol.HAServiceState state = this.proxyProvider.getHAServiceStateWithTimeout(dummyNNProxyInfo, task);
        Assert.assertNull((Object)state);
        ((Future)Mockito.verify((Object)task)).get(ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any(TimeUnit.class)));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{task});
        Assert.assertEquals((long)1L, (long)StringUtils.countMatches((CharSequence)this.proxyLog.getOutput(), (CharSequence)("Exception in NN probe task for " + dummyNNProxyInfo.proxyInfo)));
        this.proxyLog.clearOutput();
    }

    @Test
    public void testExecutionExceptionGetHAServiceStateWithTimeout() throws Exception {
        this.proxyLog.clearOutput();
        this.setupProxyProvider(1, NAMENODE_HA_STATE_PROBE_TIMEOUT_SHORT);
        AbstractNNFailoverProxyProvider.NNProxyInfo dummyNNProxyInfo = (AbstractNNFailoverProxyProvider.NNProxyInfo)Mockito.mock(AbstractNNFailoverProxyProvider.NNProxyInfo.class);
        Future task = (Future)Mockito.mock(Future.class);
        ExecutionException e = new ExecutionException(new InterruptedException("Interrupted"));
        Mockito.when(task.get(ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any(TimeUnit.class)))).thenThrow(new Throwable[]{e});
        HAServiceProtocol.HAServiceState state = this.proxyProvider.getHAServiceStateWithTimeout(dummyNNProxyInfo, task);
        Assert.assertNull((Object)state);
        ((Future)Mockito.verify((Object)task)).get(ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any(TimeUnit.class)));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{task});
        Assert.assertEquals((long)1L, (long)StringUtils.countMatches((CharSequence)this.proxyLog.getOutput(), (CharSequence)("Exception in NN probe task for " + dummyNNProxyInfo.proxyInfo)));
        this.proxyLog.clearOutput();
    }

    @Test
    public void testGetHAServiceStateWithoutTimeout() throws Exception {
        this.proxyLog.clearOutput();
        this.setupProxyProvider(1, 0L);
        HAServiceProtocol.HAServiceState state = HAServiceProtocol.HAServiceState.STANDBY;
        AbstractNNFailoverProxyProvider.NNProxyInfo dummyNNProxyInfo = (AbstractNNFailoverProxyProvider.NNProxyInfo)Mockito.mock(AbstractNNFailoverProxyProvider.NNProxyInfo.class);
        Future task = (Future)Mockito.mock(Future.class);
        Mockito.when(task.get()).thenReturn((Object)state);
        HAServiceProtocol.HAServiceState state2 = this.proxyProvider.getHAServiceStateWithTimeout(dummyNNProxyInfo, task);
        Assert.assertEquals((Object)state, (Object)state2);
        ((Future)Mockito.verify((Object)task)).get();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{task});
        Assert.assertEquals((long)1L, (long)StringUtils.countMatches((CharSequence)this.proxyLog.getOutput(), (CharSequence)("HA State for " + dummyNNProxyInfo.proxyInfo + " is " + state)));
        this.proxyLog.clearOutput();
    }

    @Test
    public void testStandbyGetHAServiceStateLongTimeout() throws Exception {
        this.setupProxyProvider(4, NAMENODE_HA_STATE_PROBE_TIMEOUT_LONG);
        this.namenodeAnswers[0].setActiveState();
        this.namenodeAnswers[1].setSlowNode(true);
        this.namenodeAnswers[3].setObserverState();
        StopWatch watch = new StopWatch();
        watch.start();
        this.doRead();
        long runtime = watch.now(TimeUnit.MILLISECONDS);
        Assert.assertTrue((String)"Read operation finished earlier than we expected", (runtime > SLOW_RESPONSE_SLEEP_TIME ? 1 : 0) != 0);
    }

    @Test(timeout=4000L)
    public void testStandbyGetHAServiceStateTimeout() throws Exception {
        this.setupProxyProvider(4, NAMENODE_HA_STATE_PROBE_TIMEOUT_SHORT);
        this.namenodeAnswers[0].setActiveState();
        this.namenodeAnswers[1].setSlowNode(true);
        this.namenodeAnswers[3].setObserverState();
        this.doRead();
    }

    private void doRead() throws Exception {
        TestObserverReadProxyProvider.doRead((ClientProtocol)this.proxyProvider.getProxy().proxy);
    }

    private void doWrite() throws Exception {
        TestObserverReadProxyProvider.doWrite((ClientProtocol)this.proxyProvider.getProxy().proxy);
    }

    private void assertHandledBy(int namenodeIdx) {
        Assert.assertEquals((Object)this.namenodeAddrs[namenodeIdx], (Object)this.proxyProvider.getLastProxy().proxyInfo);
    }

    private static void doWrite(ClientProtocol client) throws Exception {
        client.reportBadBlocks(EMPTY_BLOCKS);
    }

    private static void doRead(ClientProtocol client) throws Exception {
        client.checkAccess("/", FsAction.READ);
    }

    private static class NameNodeAnswer {
        private volatile boolean unreachable = false;
        private volatile boolean retryActive = false;
        private volatile boolean slowNode = false;
        private volatile boolean allowWrites = false;
        private volatile boolean allowReads = false;
        private ClientProtocolAnswer clientAnswer = new ClientProtocolAnswer();

        private NameNodeAnswer() {
        }

        void setUnreachable(boolean unreachable) {
            this.unreachable = unreachable;
        }

        void setSlowNode(boolean slowNode) {
            this.slowNode = slowNode;
        }

        void setActiveState() {
            this.allowReads = true;
            this.allowWrites = true;
        }

        void setStandbyState() {
            this.allowReads = false;
            this.allowWrites = false;
        }

        void setObserverState() {
            this.allowReads = true;
            this.allowWrites = false;
        }

        void setRetryActive(boolean shouldRetryActive) {
            this.retryActive = shouldRetryActive;
        }

        private class ClientProtocolAnswer
        implements Answer<Object> {
            private ClientProtocolAnswer() {
            }

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                if (NameNodeAnswer.this.unreachable) {
                    throw new IOException("Unavailable");
                }
                if (NameNodeAnswer.this.slowNode) {
                    Thread.sleep(SLOW_RESPONSE_SLEEP_TIME);
                }
                if (invocationOnMock.getMethod().getName().equals("getHAServiceState")) {
                    HAServiceProtocol.HAServiceState status = NameNodeAnswer.this.allowReads && NameNodeAnswer.this.allowWrites ? HAServiceProtocol.HAServiceState.ACTIVE : (NameNodeAnswer.this.allowReads ? HAServiceProtocol.HAServiceState.OBSERVER : HAServiceProtocol.HAServiceState.STANDBY);
                    return status;
                }
                if (NameNodeAnswer.this.retryActive) {
                    throw new RemoteException(ObserverRetryOnActiveException.class.getCanonicalName(), "Try active!");
                }
                switch (invocationOnMock.getMethod().getName()) {
                    case "reportBadBlocks": {
                        if (!NameNodeAnswer.this.allowWrites) {
                            throw new RemoteException(StandbyException.class.getCanonicalName(), "No writes!");
                        }
                        return null;
                    }
                    case "checkAccess": {
                        if (!NameNodeAnswer.this.allowReads) {
                            throw new RemoteException(StandbyException.class.getCanonicalName(), "No reads!");
                        }
                        return null;
                    }
                }
                throw new IllegalArgumentException("Only reportBadBlocks and checkAccess supported!");
            }
        }
    }
}

