/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.sharedcache;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URISyntaxException;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.api.SCMUploaderProtocol;
import org.apache.hadoop.yarn.server.api.protocolrecords.SCMUploaderNotifyRequest;
import org.apache.hadoop.yarn.server.sharedcache.SharedCacheUtil;
import org.apache.hadoop.yarn.sharedcache.SharedCacheChecksum;
import org.apache.hadoop.yarn.sharedcache.SharedCacheChecksumFactory;
import org.apache.hadoop.yarn.util.FSDownload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SharedCacheUploader
implements Callable<Boolean> {
    static final FsPermission DIRECTORY_PERMISSION = new FsPermission(493);
    static final FsPermission FILE_PERMISSION = new FsPermission(365);
    private static final Logger LOG = LoggerFactory.getLogger(SharedCacheUploader.class);
    private final LocalResource resource;
    private final Path localPath;
    private final String user;
    private final Configuration conf;
    private final SCMUploaderProtocol scmClient;
    private final FileSystem fs;
    private final FileSystem localFs;
    private final String sharedCacheRootDir;
    private final int nestedLevel;
    private final SharedCacheChecksum checksum;
    private final RecordFactory recordFactory;

    public SharedCacheUploader(LocalResource resource, Path localPath, String user, Configuration conf, SCMUploaderProtocol scmClient) throws IOException {
        this(resource, localPath, user, conf, scmClient, FileSystem.get((Configuration)conf), localPath.getFileSystem(conf));
    }

    public SharedCacheUploader(LocalResource resource, Path localPath, String user, Configuration conf, SCMUploaderProtocol scmClient, FileSystem fs, FileSystem localFs) {
        this.resource = resource;
        this.localPath = localPath;
        this.user = user;
        this.conf = conf;
        this.scmClient = scmClient;
        this.fs = fs;
        this.sharedCacheRootDir = conf.get("yarn.sharedcache.root-dir", "/sharedcache");
        this.nestedLevel = SharedCacheUtil.getCacheDepth(conf);
        this.checksum = SharedCacheChecksumFactory.getChecksum((Configuration)conf);
        this.localFs = localFs;
        this.recordFactory = RecordFactoryProvider.getRecordFactory(null);
    }

    @Override
    public Boolean call() throws Exception {
        Path tempPath = null;
        try {
            if (!this.verifyAccess()) {
                LOG.warn("User " + this.user + " is not authorized to upload file " + this.localPath.getName());
                return false;
            }
            Path actualPath = this.getActualPath();
            String checksumVal = this.computeChecksum(actualPath);
            Path directoryPath = new Path(SharedCacheUtil.getCacheEntryPath(this.nestedLevel, this.sharedCacheRootDir, checksumVal));
            this.fs.mkdirs(directoryPath, DIRECTORY_PERMISSION);
            tempPath = new Path(directoryPath, this.getTemporaryFileName(actualPath));
            if (!this.uploadFile(actualPath, tempPath)) {
                LOG.warn("Could not copy the file to the shared cache at " + tempPath);
                return false;
            }
            this.fs.setPermission(tempPath, FILE_PERMISSION);
            Path finalPath = new Path(directoryPath, actualPath.getName());
            if (!this.fs.rename(tempPath, finalPath)) {
                LOG.warn("The file already exists under " + finalPath + ". Ignoring this attempt.");
                this.deleteTempFile(tempPath);
                return false;
            }
            if (!this.notifySharedCacheManager(checksumVal, actualPath.getName())) {
                this.fs.delete(finalPath, false);
                return false;
            }
            short replication = (short)this.conf.getInt("yarn.sharedcache.nm.uploader.replication.factor", 10);
            this.fs.setReplication(finalPath, replication);
            LOG.info("File " + actualPath.getName() + " was uploaded to the shared cache at " + finalPath);
            return true;
        }
        catch (IOException e) {
            LOG.warn("Exception while uploading the file " + this.localPath.getName(), (Throwable)e);
            this.deleteTempFile(tempPath);
            throw e;
        }
    }

    @VisibleForTesting
    Path getActualPath() throws IOException {
        Path path = this.localPath;
        FileStatus status = this.localFs.getFileStatus(path);
        if (status != null && status.isDirectory()) {
            path = new Path(path, path.getName());
        }
        return path;
    }

    private void deleteTempFile(Path tempPath) {
        try {
            if (tempPath != null) {
                this.fs.delete(tempPath, false);
            }
        }
        catch (IOException ioe) {
            LOG.debug("Exception received while deleting temp files", (Throwable)ioe);
        }
    }

    @VisibleForTesting
    boolean verifyAccess() throws IOException {
        Path remotePath;
        if (this.resource.getVisibility() == LocalResourceVisibility.PUBLIC) {
            return true;
        }
        try {
            remotePath = this.resource.getResource().toPath();
        }
        catch (URISyntaxException e) {
            throw new IOException("Invalid resource", e);
        }
        FileSystem remoteFs = remotePath.getFileSystem(this.conf);
        FileStatus status = remoteFs.getFileStatus(remotePath);
        if (status.getModificationTime() != this.resource.getTimestamp()) {
            LOG.warn("The remote file " + remotePath + " has changed since it's localized; will not consider it for upload");
            return false;
        }
        if (status.getOwner().equals(this.user)) {
            return true;
        }
        return this.fileIsPublic(remotePath, remoteFs, status);
    }

    @VisibleForTesting
    boolean fileIsPublic(Path remotePath, FileSystem remoteFs, FileStatus status) throws IOException {
        return FSDownload.isPublic((FileSystem)remoteFs, (Path)remotePath, (FileStatus)status, null);
    }

    @VisibleForTesting
    boolean uploadFile(Path sourcePath, Path tempPath) throws IOException {
        return FileUtil.copy((FileSystem)this.localFs, (Path)sourcePath, (FileSystem)this.fs, (Path)tempPath, (boolean)false, (Configuration)this.conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    String computeChecksum(Path path) throws IOException {
        FSDataInputStream is = this.localFs.open(path);
        try {
            String string = this.checksum.computeChecksum((InputStream)is);
            return string;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    private String getTemporaryFileName(Path path) {
        return path.getName() + "-" + ThreadLocalRandom.current().nextLong();
    }

    @VisibleForTesting
    boolean notifySharedCacheManager(String checksumVal, String fileName) throws IOException {
        try {
            SCMUploaderNotifyRequest request = (SCMUploaderNotifyRequest)this.recordFactory.newRecordInstance(SCMUploaderNotifyRequest.class);
            request.setResourceKey(checksumVal);
            request.setFilename(fileName);
            return this.scmClient.notify(request).getAccepted();
        }
        catch (YarnException e) {
            throw new IOException(e);
        }
        catch (UndeclaredThrowableException e) {
            throw new IOException(e.getCause() == null ? e : e.getCause());
        }
    }
}

