/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.ehcache.core.spi.store;

import java.util.Arrays;
import java.util.Map;
import org.apache.hadoop.shaded.org.ehcache.core.collections.ConcurrentWeakIdentityHashMap;
import org.apache.hadoop.shaded.org.ehcache.core.spi.service.StatisticsService;
import org.apache.hadoop.shaded.org.ehcache.core.spi.store.Store;
import org.apache.hadoop.shaded.org.ehcache.core.spi.store.WrapperStore;
import org.apache.hadoop.shaded.org.ehcache.core.store.StoreSupport;
import org.apache.hadoop.shaded.org.ehcache.spi.service.Service;
import org.apache.hadoop.shaded.org.ehcache.spi.service.ServiceConfiguration;
import org.apache.hadoop.shaded.org.ehcache.spi.service.ServiceDependencies;
import org.apache.hadoop.shaded.org.ehcache.spi.service.ServiceProvider;

@ServiceDependencies(value={StatisticsService.class})
public abstract class AbstractWrapperStoreProvider
implements WrapperStore.Provider {
    private volatile ServiceProvider<Service> serviceProvider;
    private final Map<Store<?, ?>, StoreReference<?, ?>> createdStores = new ConcurrentWeakIdentityHashMap();

    @Override
    public <K, V> Store<K, V> createStore(Store.Configuration<K, V> storeConfig, ServiceConfiguration<?, ?> ... serviceConfigs) {
        Store.Provider underlyingStoreProvider = StoreSupport.selectStoreProvider(this.serviceProvider, storeConfig.getResourcePools().getResourceTypeSet(), Arrays.asList(serviceConfigs));
        Store<K, V> store = underlyingStoreProvider.createStore(storeConfig, serviceConfigs);
        Store<K, V> wrappedStore = this.wrap(store, storeConfig, serviceConfigs);
        this.serviceProvider.getService(StatisticsService.class).registerWithParent(store, wrappedStore);
        this.createdStores.put(wrappedStore, new StoreReference<K, V>(store, underlyingStoreProvider));
        return wrappedStore;
    }

    protected abstract <K, V> Store<K, V> wrap(Store<K, V> var1, Store.Configuration<K, V> var2, ServiceConfiguration<?, ?> ... var3);

    @Override
    public void releaseStore(Store<?, ?> resource) {
        StoreReference<?, ?> storeRef = this.createdStores.remove(resource);
        if (storeRef != null) {
            storeRef.release();
        }
    }

    @Override
    public void initStore(Store<?, ?> resource) {
        StoreReference<?, ?> storeRef = this.createdStores.get(resource);
        if (storeRef != null) {
            storeRef.init();
        }
    }

    @Override
    public void start(ServiceProvider<Service> serviceProvider) {
        this.serviceProvider = serviceProvider;
    }

    @Override
    public void stop() {
        this.createdStores.clear();
        this.serviceProvider = null;
    }

    private static class StoreReference<K, V> {
        private final Store<K, V> store;
        private final Store.Provider provider;

        public StoreReference(Store<K, V> store, Store.Provider provider) {
            this.store = store;
            this.provider = provider;
        }

        public void release() {
            this.provider.releaseStore(this.store);
        }

        public void init() {
            this.provider.initStore(this.store);
        }
    }
}

