/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.testng.internal.Parameters;
import org.testng.log4testng.Logger;

public class PropertyUtils {
    private static final Logger LOGGER = Logger.getLogger(PropertyUtils.class);

    public static void setProperty(Object object, String string, String string2) {
        if (object == null) {
            LOGGER.warn("Cannot set property " + string + " with value " + string2 + ". The target instance is null");
            return;
        }
        Class clazz = PropertyUtils.getPropertyType(object.getClass(), string);
        if (clazz == null) {
            LOGGER.warn("Cannot set property " + string + " with value " + string2 + ". Property class could not be found");
            return;
        }
        Object t = Parameters.convertType(clazz, string2, string);
        PropertyUtils.setPropertyRealValue(object, string, t);
    }

    public static Class getPropertyType(Class clazz, String string) {
        PropertyDescriptor propertyDescriptor;
        if (clazz == null) {
            LOGGER.warn("Cannot retrieve property class for " + string + ". Target instance class is null");
        }
        if ((propertyDescriptor = PropertyUtils.getPropertyDescriptor(clazz, string)) == null) {
            return null;
        }
        return propertyDescriptor.getPropertyType();
    }

    private static PropertyDescriptor getPropertyDescriptor(Class clazz, String string) {
        PropertyDescriptor propertyDescriptor = null;
        if (clazz == null) {
            LOGGER.warn("Cannot retrieve property " + string + ". Class is null");
        } else {
            try {
                PropertyDescriptor[] propertyDescriptorArray;
                BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
                for (PropertyDescriptor propertyDescriptor2 : propertyDescriptorArray = beanInfo.getPropertyDescriptors()) {
                    if (!propertyDescriptor2.getName().equals(string)) continue;
                    propertyDescriptor = propertyDescriptor2;
                    break;
                }
            }
            catch (IntrospectionException introspectionException) {
                LOGGER.warn("Cannot retrieve property " + string + ". Cause is: " + introspectionException);
            }
        }
        return propertyDescriptor;
    }

    public static void setPropertyRealValue(Object object, String string, Object object2) {
        if (object == null) {
            LOGGER.warn("Cannot set property " + string + " with value " + object2 + ". Targe instance is null");
            return;
        }
        PropertyDescriptor propertyDescriptor = PropertyUtils.getPropertyDescriptor(object.getClass(), string);
        if (propertyDescriptor == null) {
            LOGGER.warn("Cannot set property " + string + " with value " + object2 + ". Property does not exist");
            return;
        }
        Method method = propertyDescriptor.getWriteMethod();
        try {
            method.invoke(object, object2);
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            LOGGER.warn("Cannot set property " + string + " with value " + object2 + ". Cause " + reflectiveOperationException);
        }
    }
}

