/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.converters;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.geode.management.internal.cli.converters.FilePathStringConverter;
import org.springframework.shell.core.Completion;
import org.springframework.shell.core.Converter;
import org.springframework.shell.core.MethodTarget;

public class JarDirPathConverter
implements Converter<String> {
    private FilePathStringConverter delegate = new FilePathStringConverter();

    public void setDelegate(FilePathStringConverter delegate) {
        this.delegate = delegate;
    }

    @Override
    public boolean supports(Class<?> type, String optionContext) {
        return String.class.equals(type) && optionContext.contains("geode.converter.jardir:disable-string-converter");
    }

    @Override
    public String convertFromText(String value, Class<?> targetType, String optionContext) {
        return value;
    }

    @Override
    public boolean getAllPossibleValues(List<Completion> completions, Class<?> targetType, String existingData, String optionContext, MethodTarget target) {
        ArrayList<Completion> allCompletions = new ArrayList<Completion>();
        this.delegate.getAllPossibleValues(allCompletions, targetType, existingData, optionContext, target);
        completions.addAll(allCompletions.stream().filter(JarDirPathConverter::isDirWithDirsOrDirWithJars).collect(Collectors.toList()));
        return JarDirPathConverter.notAllAreJars(completions);
    }

    static boolean isDirWithDirsOrDirWithJars(Completion dir) {
        return JarDirPathConverter.isDirWithDirsOrDirWithJars(dir.getValue());
    }

    static boolean isDirWithDirsOrDirWithJars(String dir) {
        File d = new File(dir);
        if (!d.isDirectory()) {
            return false;
        }
        File[] listing = d.listFiles();
        if (listing == null) {
            return false;
        }
        return JarDirPathConverter.hasSubdirs(listing) || JarDirPathConverter.hasJars(listing);
    }

    private static boolean hasSubdirs(File[] listing) {
        return Arrays.stream(listing).anyMatch(File::isDirectory);
    }

    private static boolean hasJars(File[] listing) {
        return Arrays.stream(listing).anyMatch(f -> f.getName().endsWith(".jar"));
    }

    private static boolean notAllAreJars(List<Completion> completions) {
        return completions.stream().anyMatch(c -> !c.getValue().endsWith(".jar"));
    }
}

