/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.logging.internal.log4j.LogLevel;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.AbstractCliAroundInterceptor;
import org.apache.geode.management.internal.cli.GfshParseResult;
import org.apache.geode.management.internal.cli.functions.ExportLogsFunction;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.logging.log4j.Logger;

public class ExportLogsInterceptor
extends AbstractCliAroundInterceptor {
    private static final Logger logger = LogService.getLogger();
    private static final Pattern DATE_AND_TIME_PATTERN = Pattern.compile("^\\d{4}(/\\d{2}){5}/\\d{3}/.{3,}");
    private static final Pattern DATE_ONLY_PATTERN = Pattern.compile("^\\d{4}(/\\d{2}){2}$");

    @Override
    public ResultModel preExecution(GfshParseResult parseResult) {
        String end;
        if (parseResult.getParamValueAsString("group") != null && parseResult.getParamValueAsString("member") != null) {
            return ResultModel.createError("Can't specify both group and member.");
        }
        String logLevel = parseResult.getParamValueAsString("log-level");
        if (StringUtils.isBlank((CharSequence)logLevel) || LogLevel.getLevel((String)logLevel) == null) {
            return ResultModel.createError("Invalid log level: " + logLevel);
        }
        String start = parseResult.getParamValueAsString("start-time");
        ResultModel formatErrorResult = this.checkStartAndEndFormat(start, end = parseResult.getParamValueAsString("end-time"));
        if (formatErrorResult != null) {
            return formatErrorResult;
        }
        ResultModel parseErrorResult = this.checkStartAndEndParsing(start, end);
        if (parseErrorResult != null) {
            return parseErrorResult;
        }
        LocalDateTime startTime = ExportLogsFunction.parseTime(start);
        LocalDateTime endTime = ExportLogsFunction.parseTime(end);
        if (startTime != null && endTime != null && startTime.isAfter(endTime)) {
            return ResultModel.createError("start-time has to be earlier than end-time.");
        }
        boolean onlyLogs = (Boolean)parseResult.getParamValue("logs-only");
        boolean onlyStats = (Boolean)parseResult.getParamValue("stats-only");
        if (onlyLogs && onlyStats) {
            return ResultModel.createError("logs-only and stats-only can't both be true");
        }
        return ResultModel.createInfo("");
    }

    @Override
    public ResultModel postExecution(GfshParseResult parseResult, ResultModel commandResult, Path tempFile) {
        String endTime;
        StringBuilder output = new StringBuilder();
        String startTime = parseResult.getParamValueAsString("start-time");
        if (startTime != null && !startTime.isEmpty()) {
            output.append("Start time parsed as ").append(ExportLogsFunction.parseTime(startTime)).append(" ").append(TimeZone.getDefault().getDisplayName(false, 0)).append("\n");
        }
        if ((endTime = parseResult.getParamValueAsString("end-time")) != null && !endTime.isEmpty()) {
            output.append("End time parsed as ").append(ExportLogsFunction.parseTime(endTime)).append(" ").append(TimeZone.getDefault().getDisplayName(false, 0)).append("\n");
        }
        if (tempFile != null) {
            String dirName = parseResult.getParamValueAsString("dir");
            Path dirPath = StringUtils.isBlank((CharSequence)dirName) ? Paths.get(System.getProperty("user.dir"), new String[0]).toAbsolutePath() : Paths.get(dirName, new String[0]).toAbsolutePath();
            String fileName = "exportedLogs_" + System.currentTimeMillis() + ".zip";
            File exportedLogFile = dirPath.resolve(fileName).toFile();
            try {
                FileUtils.copyFile((File)tempFile.toFile(), (File)exportedLogFile);
                FileUtils.deleteQuietly((File)tempFile.toFile());
                output.append("Logs exported to: ").append(exportedLogFile.getAbsolutePath());
                return ResultModel.createInfo(output.toString());
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return ResultModel.createError(e.getMessage());
            }
        }
        if (commandResult.getStatus() != Result.Status.OK) {
            return commandResult;
        }
        output.append("Logs exported to the connected member's file system: ").append(commandResult.getFileToDownload().toString());
        return ResultModel.createInfo(output.toString());
    }

    private ResultModel checkStartAndEndFormat(String start, String end) {
        StringBuilder formatErrorMessage = new StringBuilder();
        boolean formatError = false;
        if (start != null && !DATE_AND_TIME_PATTERN.matcher(start).matches() && !DATE_ONLY_PATTERN.matcher(start).matches()) {
            formatErrorMessage.append("start-time");
            formatError = true;
        }
        if (end != null && !DATE_AND_TIME_PATTERN.matcher(end).matches() && !DATE_ONLY_PATTERN.matcher(end).matches()) {
            if (formatError) {
                formatErrorMessage.append(" and ");
            }
            formatErrorMessage.append("end-time");
            formatError = true;
        }
        if (formatError) {
            formatErrorMessage.append(" had incorrect format. Valid formats are ").append("yyyy/MM/dd").append(" and ").append("yyyy/MM/dd/HH/mm/ss/SSS/z");
            return ResultModel.createError(formatErrorMessage.toString());
        }
        return null;
    }

    private ResultModel checkStartAndEndParsing(String start, String end) {
        StringBuilder parseErrorMessage = new StringBuilder();
        boolean parseError = false;
        SimpleDateFormat dateAndTimeFormat = new SimpleDateFormat("yyyy/MM/dd/HH/mm/ss/SSS/z");
        SimpleDateFormat dateOnlyFormat = new SimpleDateFormat("yyyy/MM/dd");
        if (start != null) {
            try {
                if (start.length() > 10) {
                    dateAndTimeFormat.parse(start);
                } else {
                    dateOnlyFormat.parse(start);
                }
            }
            catch (ParseException e) {
                parseErrorMessage.append("start-time");
                parseError = true;
            }
        }
        if (end != null) {
            try {
                if (end.length() > 10) {
                    dateAndTimeFormat.parse(end);
                } else {
                    dateOnlyFormat.parse(end);
                }
            }
            catch (ParseException e) {
                if (parseError) {
                    parseErrorMessage.append(" and ");
                }
                parseErrorMessage.append("end-time");
                parseError = true;
            }
        }
        if (parseError) {
            parseErrorMessage.append(" could not be parsed to valid date/time.");
            return ResultModel.createError(parseErrorMessage.toString());
        }
        return null;
    }
}

