/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.table;

import java.util.Arrays;
import org.springframework.shell.table.Aligner;

public enum SimpleVerticalAligner implements Aligner
{
    top,
    middle,
    bottom;


    @Override
    public String[] align(String[] text, int cellWidth, int cellHeight) {
        int padBefore;
        int padAfter;
        int row;
        Object[] result = new String[cellHeight];
        int blanksBefore = 0;
        int blanksAfter = 0;
        for (row = 0; row < text.length && (text[row] == null || text[row].trim().equals("")); ++row) {
            ++blanksBefore;
        }
        for (row = text.length - 1; row >= 0 && (text[row] == null || text[row].trim().equals("")); --row) {
            ++blanksAfter;
        }
        String filler = this.spaces(cellWidth);
        int nonBlankLines = text.length - blanksAfter - blanksBefore;
        int paddingToDistribute = cellHeight - nonBlankLines;
        switch (this) {
            case middle: {
                int carry = paddingToDistribute % 2;
                padBefore = padAfter = (paddingToDistribute -= carry) / 2;
                padAfter += carry;
                break;
            }
            case bottom: {
                padBefore = paddingToDistribute;
                padAfter = 0;
                break;
            }
            case top: {
                padBefore = 0;
                padAfter = paddingToDistribute;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        Arrays.fill(result, 0, padBefore, filler);
        System.arraycopy(text, blanksBefore, result, padBefore, nonBlankLines);
        Arrays.fill(result, result.length - padAfter, result.length, filler);
        return result;
    }

    private String spaces(int width) {
        char[] data = new char[width];
        Arrays.fill(data, ' ');
        return new String(data);
    }
}

