/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.geode.management.ManagementException;
import org.apache.geode.management.internal.FilterParam;

public class StringBasedFilter {
    private final FilterParam params;
    private final List<Pattern> exclusionPatternList;
    private final List<Pattern> inclusionPatternList;

    public StringBasedFilter(FilterParam params) {
        this.params = params;
        this.exclusionPatternList = new ArrayList<Pattern>();
        this.inclusionPatternList = new ArrayList<Pattern>();
        this.compileFilterList(params.getExclusionList(), this.exclusionPatternList);
        this.compileFilterList(params.getInclusionList(), this.inclusionPatternList);
    }

    public boolean isExcluded(String tokenToMatch) {
        if (this.params.isDefaultExcludeFilter()) {
            return false;
        }
        tokenToMatch = this.formatStringTokens(tokenToMatch);
        for (Pattern pattern : this.exclusionPatternList) {
            Matcher matcher = pattern.matcher(tokenToMatch);
            if (!matcher.find()) continue;
            return true;
        }
        return false;
    }

    public boolean isIncluded(String tokenToMatch) {
        if (this.params.isDefaultIncludeFilter()) {
            return true;
        }
        tokenToMatch = this.formatStringTokens(tokenToMatch);
        for (Pattern pattern : this.inclusionPatternList) {
            Matcher matcher = pattern.matcher(tokenToMatch);
            if (!matcher.find()) continue;
            return true;
        }
        return false;
    }

    private void compileFilterList(String[] list, List<Pattern> patternList) {
        for (String s : list) {
            try {
                s = this.formatStringTokens(s);
                Pattern pattern = s.contains("*") ? Pattern.compile(s) : Pattern.compile(s, 16);
                patternList.add(pattern);
            }
            catch (NullPointerException e) {
                throw new ManagementException(e);
            }
        }
    }

    private String formatStringTokens(String value) {
        value = value.replace('<', '-');
        value = value.replace('>', '-');
        value = value.replace('(', '-');
        if ((value = value.replace(')', '-')).length() < 1) {
            value = "nothing";
        }
        return value;
    }
}

