/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.statistics;

import java.net.UnknownHostException;
import org.apache.geode.Statistics;
import org.apache.geode.internal.inet.LocalHostUtil;
import org.apache.geode.internal.lang.SystemUtils;
import org.apache.geode.internal.statistics.LocalStatisticsImpl;
import org.apache.geode.internal.statistics.platform.LinuxProcFsStatistics;
import org.apache.geode.internal.statistics.platform.LinuxProcessStats;
import org.apache.geode.internal.statistics.platform.LinuxSystemStats;
import org.apache.geode.internal.statistics.platform.OsStatisticsFactory;
import org.apache.geode.internal.statistics.platform.ProcessStats;

public class OsStatisticsProvider {
    private static final int PROCESS_STAT_FLAG = 1;
    private static final int SYSTEM_STAT_FLAG = 2;
    private final boolean osStatsSupported = SystemUtils.isLinux();

    public boolean osStatsSupported() {
        return this.osStatsSupported;
    }

    private OsStatisticsProvider() {
    }

    public static OsStatisticsProvider build() {
        return new OsStatisticsProvider();
    }

    int initOSStats() {
        return LinuxProcFsStatistics.init();
    }

    void closeOSStats() {
        LinuxProcFsStatistics.close();
    }

    void readyRefreshOSStats() {
        LinuxProcFsStatistics.readyRefresh();
    }

    private void refreshProcess(LocalStatisticsImpl statistics) {
        int pid = (int)statistics.getNumericId();
        LinuxProcFsStatistics.refreshProcess(pid, statistics);
    }

    private void refreshSystem(LocalStatisticsImpl statistics) {
        LinuxProcFsStatistics.refreshSystem(statistics);
    }

    public void refresh(LocalStatisticsImpl statistics) {
        int flags = statistics.getOsStatFlags();
        if ((flags & 1) != 0) {
            this.refreshProcess(statistics);
        } else if ((flags & 2) != 0) {
            this.refreshSystem(statistics);
        } else {
            throw new RuntimeException(String.format("Unexpected os stats flags %s", flags));
        }
    }

    Statistics newProcess(OsStatisticsFactory osStatisticsFactory, long pid, String name) {
        Statistics statistics = osStatisticsFactory.createOsStatistics(LinuxProcessStats.getType(), name, pid, 1);
        return statistics;
    }

    ProcessStats newProcessStats(Statistics statistics) {
        if (statistics instanceof LocalStatisticsImpl) {
            this.refresh((LocalStatisticsImpl)statistics);
        }
        return LinuxProcessStats.createProcessStats(statistics);
    }

    void newSystem(OsStatisticsFactory osStatisticsFactory, long id) {
        Statistics statistics = osStatisticsFactory.createOsStatistics(LinuxSystemStats.getType(), this.getHostSystemName(), id, 2);
        if (statistics instanceof LocalStatisticsImpl) {
            this.refreshSystem((LocalStatisticsImpl)statistics);
        }
    }

    private String getHostSystemName() {
        try {
            return LocalHostUtil.getCanonicalLocalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return "unknownHostName";
        }
    }
}

