/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.classloader;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.geode.internal.classloader.ChildFirstClassLoader;

public class DeployJarChildFirstClassLoader
extends ChildFirstClassLoader {
    private final String artifactId;
    public final Map<String, DeployJarChildFirstClassLoader> artifactIdsToClassLoader;

    public DeployJarChildFirstClassLoader(Map<String, DeployJarChildFirstClassLoader> artifactIdsToClassLoader, URL[] urls, String artifactId, ClassLoader parent) {
        super(urls, parent);
        this.artifactIdsToClassLoader = artifactIdsToClassLoader;
        this.artifactId = artifactId;
        this.artifactIdsToClassLoader.put(this.artifactId, this);
    }

    @Override
    public Class loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    @Override
    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class c = this.thisIsOld() ? this.searchParent(name) : super.loadClass(name, resolve);
        if (c == null) {
            for (DeployJarChildFirstClassLoader sibling : this.artifactIdsToClassLoader.values().stream().filter(Objects::nonNull).collect(Collectors.toList())) {
                try {
                    c = sibling.findClass(name);
                    if (c == null) continue;
                    break;
                }
                catch (ClassNotFoundException | NoClassDefFoundError throwable) {
                }
            }
        }
        return c;
    }

    public Class findClass(String name) throws ClassNotFoundException {
        if (this.thisIsOld()) {
            return null;
        }
        return super.findClass(name);
    }

    @Override
    public URL findResource(String name) {
        if (this.thisIsOld()) {
            return null;
        }
        return super.findResource(name);
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        if (this.thisIsOld()) {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }
        return super.findResources(name);
    }

    public boolean thisIsOld() {
        return this.artifactIdsToClassLoader.get(this.artifactId) != this;
    }

    public String getArtifactId() {
        return this.artifactId;
    }
}

