/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.persistence;

import java.time.Duration;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import org.apache.geode.CancelCriterion;
import org.apache.geode.internal.cache.persistence.InternalPersistenceAdvisor;
import org.apache.geode.internal.cache.persistence.MembershipChangeListener;

public class MembershipChangeListenerFactory {
    private Duration warningDelay;
    private Duration pollDuration;
    private BooleanSupplier cancelCondition;
    private Runnable warning;

    public static BooleanSupplier cancelCondition(InternalPersistenceAdvisor persistenceAdvisor, CancelCriterion cancelCriterion) {
        return () -> {
            persistenceAdvisor.checkInterruptedByShutdownAll();
            cancelCriterion.checkCancelInProgress(null);
            return persistenceAdvisor.isClosed();
        };
    }

    public MembershipChangeListenerFactory setWarningDelay(Duration warningDelay) {
        this.warningDelay = warningDelay;
        return this;
    }

    public MembershipChangeListenerFactory setPollDuration(Duration pollDuration) {
        this.pollDuration = pollDuration;
        return this;
    }

    public MembershipChangeListenerFactory setCancelCondition(BooleanSupplier cancelCondition) {
        this.cancelCondition = cancelCondition;
        return this;
    }

    public MembershipChangeListenerFactory setWarning(Runnable warning) {
        this.warning = warning;
        return this;
    }

    public MembershipChangeListener create() {
        return this.create(this.warningDelay, this.pollDuration, this.cancelCondition, this.warning);
    }

    public MembershipChangeListener create(Duration warningDelay, Duration pollDuration, BooleanSupplier cancelCondition, Runnable warning) {
        Objects.requireNonNull(warningDelay);
        Objects.requireNonNull(pollDuration);
        int diff = warningDelay.compareTo(pollDuration);
        if (diff >= 0) {
            throw new IllegalArgumentException("Warning delay \"" + warningDelay.getSeconds() + "\" seconds must be less than poll duration \"" + pollDuration.getSeconds() + "\" seconds.");
        }
        return new MembershipChangeListener(warningDelay, pollDuration, cancelCondition, warning);
    }
}

