/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.entries;

import java.util.UUID;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.internal.cache.InlineKeyHelper;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.RegionEntryFactory;
import org.apache.geode.internal.cache.entries.OffHeapRegionEntry;
import org.apache.geode.internal.cache.entries.VersionedStatsDiskRegionEntry;
import org.apache.geode.internal.cache.entries.VersionedStatsDiskRegionEntryHeap;
import org.apache.geode.internal.cache.entries.VersionedStatsDiskRegionEntryOffHeapIntKey;
import org.apache.geode.internal.cache.entries.VersionedStatsDiskRegionEntryOffHeapLongKey;
import org.apache.geode.internal.cache.entries.VersionedStatsDiskRegionEntryOffHeapObjectKey;
import org.apache.geode.internal.cache.entries.VersionedStatsDiskRegionEntryOffHeapStringKey1;
import org.apache.geode.internal.cache.entries.VersionedStatsDiskRegionEntryOffHeapStringKey2;
import org.apache.geode.internal.cache.entries.VersionedStatsDiskRegionEntryOffHeapUUIDKey;

public abstract class VersionedStatsDiskRegionEntryOffHeap
extends VersionedStatsDiskRegionEntry
implements OffHeapRegionEntry {
    @Immutable
    private static final VersionedStatsDiskRegionEntryOffHeapFactory factory = new VersionedStatsDiskRegionEntryOffHeapFactory();

    public VersionedStatsDiskRegionEntryOffHeap(RegionEntryContext context, Object value) {
        super(context, value);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VersionedStatsDiskRegionEntryOffHeapFactory
    implements RegionEntryFactory {
        private VersionedStatsDiskRegionEntryOffHeapFactory() {
        }

        @Override
        public RegionEntry createEntry(RegionEntryContext context, Object key, Object value) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key.getClass();
                if (keyClass == Integer.class) {
                    return new VersionedStatsDiskRegionEntryOffHeapIntKey(context, (Integer)key, value);
                }
                if (keyClass == Long.class) {
                    return new VersionedStatsDiskRegionEntryOffHeapLongKey(context, (Long)key, value);
                }
                if (keyClass == String.class) {
                    String skey = (String)key;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VersionedStatsDiskRegionEntryOffHeapStringKey1(context, skey, value, byteEncoded);
                        }
                        return new VersionedStatsDiskRegionEntryOffHeapStringKey2(context, skey, value, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VersionedStatsDiskRegionEntryOffHeapUUIDKey(context, (UUID)key, value);
                }
            }
            return new VersionedStatsDiskRegionEntryOffHeapObjectKey(context, key, value);
        }

        @Override
        public Class getEntryClass() {
            return VersionedStatsDiskRegionEntryOffHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return this;
        }

        @Override
        public RegionEntryFactory makeOnHeap() {
            return VersionedStatsDiskRegionEntryHeap.getEntryFactory();
        }
    }
}

