/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin;

public class ListenerIdMap {
    protected Entry[] table;
    private int count;
    private int threshold;
    private final float loadFactor;

    public ListenerIdMap(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException(String.format("Illegal Initial Capacity: %s", initialCapacity));
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException(String.format("Illegal Load factor: %s", Float.valueOf(loadFactor)));
        }
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.table = new Entry[initialCapacity];
        this.threshold = (int)((float)initialCapacity * loadFactor);
    }

    public ListenerIdMap() {
        this(11, 0.75f);
    }

    public int size() {
        return this.count;
    }

    public boolean containsKey(int key) {
        Entry[] table = this.table;
        int bucket = Math.abs(key) % table.length;
        Entry e = table[bucket];
        while (e != null) {
            if (e.key == key) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public Object get(int key) {
        Entry[] table = this.table;
        int bucket = Math.abs(key) % table.length;
        Entry e = table[bucket];
        while (e != null) {
            if (e.key == key) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    private void rehash() {
        int oldCapacity = this.table.length;
        Entry[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        Entry[] newMap = new Entry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            Entry old = oldMap[i];
            while (old != null) {
                Entry e = old;
                old = old.next;
                int index = Math.abs(e.key) % newCapacity;
                e.next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    public Object put(int key, Object value) {
        Entry[] table = this.table;
        int bucket = Math.abs(key) % table.length;
        Entry e = table[bucket];
        while (e != null) {
            if (e.key == key) {
                Object old = e.value;
                e.value = value;
                return old;
            }
            e = e.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            table = this.table;
            bucket = Math.abs(key) % table.length;
        }
        e = new Entry();
        e.key = key;
        e.value = value;
        e.next = table[bucket];
        table[bucket] = e;
        ++this.count;
        return null;
    }

    public Object remove(int key) {
        Entry[] table = this.table;
        int bucket = Math.abs(key) % table.length;
        Entry e = table[bucket];
        Entry prev = null;
        while (e != null) {
            if (key == e.key) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    table[bucket] = e.next;
                }
                --this.count;
                Object oldValue = e.value;
                e.value = null;
                return oldValue;
            }
            prev = e;
            e = e.next;
        }
        return null;
    }

    public Object[] values() {
        Object[] values = new Object[this.size()];
        Entry[] table = this.table;
        int i = 0;
        Entry[] entryArray = table;
        int n = entryArray.length;
        for (int j = 0; j < n; ++j) {
            Entry entry;
            Entry e = entry = entryArray[j];
            while (e != null) {
                values[i++] = e.value;
                e = e.next;
            }
        }
        return values;
    }

    public Entry[] entries() {
        Entry[] entries = new Entry[this.size()];
        Entry[] table = this.table;
        int i = 0;
        Entry[] entryArray = table;
        int n = entryArray.length;
        for (int j = 0; j < n; ++j) {
            Entry entry;
            Entry e = entry = entryArray[j];
            while (e != null) {
                entries[i++] = e;
                e = e.next;
            }
        }
        return entries;
    }

    public EntryIterator iterator() {
        return new EntryIterator();
    }

    public class EntryIterator {
        private int index;
        private Entry next;

        public Entry next() {
            while (this.next == null && this.index < ListenerIdMap.this.table.length) {
                if (ListenerIdMap.this.table[this.index] != null) {
                    this.next = ListenerIdMap.this.table[this.index];
                }
                ++this.index;
            }
            Entry oldNext = this.next;
            if (oldNext != null) {
                this.next = oldNext.next;
            }
            return oldNext;
        }
    }

    public static class Entry {
        int key;
        Object value;
        Entry next;

        public int getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

