/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.security;

import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.query.internal.QRegion;
import org.apache.geode.cache.query.security.MethodInvocationAuthorizer;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.internal.security.SecurityServiceFactory;
import org.apache.geode.security.NotAuthorizedException;
import org.apache.geode.security.ResourcePermission;

public final class RestrictedMethodAuthorizer
implements MethodInvocationAuthorizer {
    public static final String UNAUTHORIZED_STRING = "Unauthorized access to method: ";
    @Immutable
    static final Set<String> FORBIDDEN_METHODS = Collections.unmodifiableSet(RestrictedMethodAuthorizer.createForbiddenList());
    @Immutable
    static final Map<String, Set<Class>> GEODE_ALLOWED_METHODS = Collections.unmodifiableMap(RestrictedMethodAuthorizer.createGeodeAcceptanceList());
    @Immutable
    static final Map<String, Set<Class>> DEFAULT_ALLOWED_METHODS = Collections.unmodifiableMap(RestrictedMethodAuthorizer.createDefaultAcceptanceList());
    final SecurityService securityService;
    private final Set<String> forbiddenMethods;
    private final Map<String, Set<Class>> allowedMethodsPerClass;
    private final Map<String, Set<Class>> allowedGeodeMethodsPerClass;

    private static Set<String> createForbiddenList() {
        HashSet<String> forbiddenList = new HashSet<String>();
        forbiddenList.add("getClass");
        forbiddenList.add("readObject");
        forbiddenList.add("readResolve");
        forbiddenList.add("readObjectNoData");
        forbiddenList.add("writeObject");
        forbiddenList.add("writeReplace");
        return forbiddenList;
    }

    private static Map<String, Set<Class>> createGeodeAcceptanceList() {
        HashMap<String, Set<Class>> acceptanceListMap = new HashMap<String, Set<Class>>();
        Set<Class> objectCallers = new HashSet<Class<Object>>();
        objectCallers.add(Object.class);
        objectCallers = Collections.unmodifiableSet(objectCallers);
        acceptanceListMap.put("equals", objectCallers);
        acceptanceListMap.put("toString", objectCallers);
        Set<Class> entryCallers = new HashSet<Class<Region.Entry>>();
        entryCallers.add(Region.Entry.class);
        entryCallers = Collections.unmodifiableSet(entryCallers);
        acceptanceListMap.put("getKey", entryCallers);
        acceptanceListMap.put("getValue", entryCallers);
        Set<Class> regionCallers = new HashSet<Class>();
        regionCallers.add(Region.class);
        regionCallers.add(QRegion.class);
        regionCallers = Collections.unmodifiableSet(regionCallers);
        acceptanceListMap.put("containsKey", regionCallers);
        acceptanceListMap.put("entrySet", regionCallers);
        acceptanceListMap.put("get", regionCallers);
        acceptanceListMap.put("keySet", regionCallers);
        acceptanceListMap.put("values", regionCallers);
        acceptanceListMap.put("getEntries", regionCallers);
        acceptanceListMap.put("getValues", regionCallers);
        return acceptanceListMap;
    }

    private static Map<String, Set<Class>> createDefaultAcceptanceList() {
        HashMap<String, Set<Class>> acceptanceListMap = new HashMap<String, Set<Class>>();
        Set<Class> objectCallers = new HashSet<Class<Object>>();
        objectCallers.add(Object.class);
        objectCallers = Collections.unmodifiableSet(objectCallers);
        acceptanceListMap.put("compareTo", objectCallers);
        acceptanceListMap.put("equals", objectCallers);
        acceptanceListMap.put("toString", objectCallers);
        Set<Class> booleanCallers = new HashSet<Class<Boolean>>();
        booleanCallers.add(Boolean.class);
        booleanCallers = Collections.unmodifiableSet(booleanCallers);
        acceptanceListMap.put("booleanValue", booleanCallers);
        Set<Class> numericCallers = new HashSet<Class<Number>>();
        numericCallers.add(Number.class);
        numericCallers = Collections.unmodifiableSet(numericCallers);
        acceptanceListMap.put("byteValue", numericCallers);
        acceptanceListMap.put("doubleValue", numericCallers);
        acceptanceListMap.put("floatValue", numericCallers);
        acceptanceListMap.put("intValue", numericCallers);
        acceptanceListMap.put("longValue", numericCallers);
        acceptanceListMap.put("shortValue", numericCallers);
        Set<Class> dateCallers = new HashSet<Class<Date>>();
        dateCallers.add(Date.class);
        dateCallers = Collections.unmodifiableSet(dateCallers);
        acceptanceListMap.put("after", dateCallers);
        acceptanceListMap.put("before", dateCallers);
        acceptanceListMap.put("getTime", dateCallers);
        Set<Class> timestampCallers = new HashSet<Class<Timestamp>>();
        timestampCallers.add(Timestamp.class);
        timestampCallers = Collections.unmodifiableSet(timestampCallers);
        acceptanceListMap.put("getNanos", timestampCallers);
        Set<Class> stringCallers = new HashSet<Class<String>>();
        stringCallers.add(String.class);
        stringCallers = Collections.unmodifiableSet(stringCallers);
        acceptanceListMap.put("charAt", stringCallers);
        acceptanceListMap.put("codePointAt", stringCallers);
        acceptanceListMap.put("codePointBefore", stringCallers);
        acceptanceListMap.put("codePointCount", stringCallers);
        acceptanceListMap.put("compareToIgnoreCase", stringCallers);
        acceptanceListMap.put("concat", stringCallers);
        acceptanceListMap.put("contains", stringCallers);
        acceptanceListMap.put("contentEquals", stringCallers);
        acceptanceListMap.put("endsWith", stringCallers);
        acceptanceListMap.put("equalsIgnoreCase", stringCallers);
        acceptanceListMap.put("getBytes", stringCallers);
        acceptanceListMap.put("hashCode", stringCallers);
        acceptanceListMap.put("indexOf", stringCallers);
        acceptanceListMap.put("intern", stringCallers);
        acceptanceListMap.put("isEmpty", stringCallers);
        acceptanceListMap.put("lastIndexOf", stringCallers);
        acceptanceListMap.put("length", stringCallers);
        acceptanceListMap.put("matches", stringCallers);
        acceptanceListMap.put("offsetByCodePoints", stringCallers);
        acceptanceListMap.put("regionMatches", stringCallers);
        acceptanceListMap.put("replace", stringCallers);
        acceptanceListMap.put("replaceAll", stringCallers);
        acceptanceListMap.put("replaceFirst", stringCallers);
        acceptanceListMap.put("split", stringCallers);
        acceptanceListMap.put("startsWith", stringCallers);
        acceptanceListMap.put("substring", stringCallers);
        acceptanceListMap.put("toCharArray", stringCallers);
        acceptanceListMap.put("toLowerCase", stringCallers);
        acceptanceListMap.put("toUpperCase", stringCallers);
        acceptanceListMap.put("trim", stringCallers);
        Set<Class> mapEntryCallers = new HashSet<Class<Map.Entry>>();
        mapEntryCallers.add(Map.Entry.class);
        mapEntryCallers = Collections.unmodifiableSet(mapEntryCallers);
        acceptanceListMap.put("getKey", mapEntryCallers);
        acceptanceListMap.put("getValue", mapEntryCallers);
        Set<Class> regionCallers = new HashSet<Class>();
        regionCallers.add(Map.class);
        regionCallers.add(QRegion.class);
        regionCallers = Collections.unmodifiableSet(regionCallers);
        acceptanceListMap.put("containsKey", regionCallers);
        acceptanceListMap.put("entrySet", regionCallers);
        acceptanceListMap.put("get", regionCallers);
        acceptanceListMap.put("keySet", regionCallers);
        acceptanceListMap.put("values", regionCallers);
        acceptanceListMap.put("getEntries", regionCallers);
        acceptanceListMap.put("getValues", regionCallers);
        return acceptanceListMap;
    }

    Set<String> getForbiddenMethods() {
        return this.forbiddenMethods;
    }

    Map<String, Set<Class>> getAllowedMethodsPerClass() {
        return this.allowedMethodsPerClass;
    }

    Map<String, Set<Class>> getAllowedGeodeMethodsPerClass() {
        return this.allowedGeodeMethodsPerClass;
    }

    public RestrictedMethodAuthorizer(Cache cache) {
        Objects.requireNonNull(cache, "Cache should be provided to configure the authorizer.");
        if (cache instanceof InternalCache) {
            this.securityService = ((InternalCache)cache).getSecurityService();
        } else {
            Objects.requireNonNull(cache.getDistributedSystem(), "Distributed system properties should be provided to configure the authorizer.");
            this.securityService = SecurityServiceFactory.create(cache.getDistributedSystem().getSecurityProperties());
        }
        this.forbiddenMethods = FORBIDDEN_METHODS;
        this.allowedMethodsPerClass = DEFAULT_ALLOWED_METHODS;
        this.allowedGeodeMethodsPerClass = GEODE_ALLOWED_METHODS;
    }

    private boolean isAllowedByDefault(Method method, Object target) {
        String methodName = method.getName();
        Set<Class> allowedClasses = this.allowedMethodsPerClass.get(methodName);
        if (allowedClasses == null) {
            return false;
        }
        for (Class clazz : allowedClasses) {
            if (!clazz.isAssignableFrom(target.getClass())) continue;
            return true;
        }
        return false;
    }

    private void authorizeRegionAccess(SecurityService securityService, Object target) {
        if (target instanceof Region) {
            String regionName = ((Region)target).getName();
            securityService.authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.READ, regionName);
        }
    }

    public boolean isAllowedGeodeMethod(Method method, Object target) {
        String methodName = method.getName();
        Set<Class> allowedGeodeClassesForMethod = this.allowedGeodeMethodsPerClass.get(methodName);
        if (allowedGeodeClassesForMethod == null) {
            return false;
        }
        for (Class clazz : allowedGeodeClassesForMethod) {
            if (!clazz.isAssignableFrom(target.getClass())) continue;
            try {
                this.authorizeRegionAccess(this.securityService, target);
                return true;
            }
            catch (NotAuthorizedException noAuthorizedException) {
                return false;
            }
        }
        return false;
    }

    public boolean isPermanentlyForbiddenMethod(Method method, Object target) {
        return this.forbiddenMethods.contains(method.getName());
    }

    @Override
    public boolean authorize(Method method, Object target) {
        if (!this.isAllowedByDefault(method, target)) {
            return false;
        }
        try {
            this.authorizeRegionAccess(this.securityService, target);
        }
        catch (NotAuthorizedException noAuthorizedException) {
            return false;
        }
        return true;
    }
}

