/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.geode.CopyHelper;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.Struct;
import org.apache.geode.cache.query.internal.StructImpl;
import org.apache.geode.cache.query.internal.types.StructTypeImpl;
import org.apache.geode.cache.query.types.CollectionType;
import org.apache.geode.cache.query.types.ObjectType;
import org.apache.geode.pdx.PdxInstance;
import org.apache.geode.pdx.internal.PdxString;

public class ResultsCollectionPdxDeserializerWrapper
implements SelectResults {
    SelectResults results;
    private boolean copyOnRead = false;

    public ResultsCollectionPdxDeserializerWrapper() {
    }

    public ResultsCollectionPdxDeserializerWrapper(SelectResults results, boolean copyOnRead) {
        this.results = results;
        this.copyOnRead = copyOnRead;
    }

    @Override
    public Iterator iterator() {
        if (this.results == null) {
            return new SelectResultsPdxInstanceIterator(Collections.emptyIterator());
        }
        return new SelectResultsPdxInstanceIterator(this.results.iterator());
    }

    private Object extractPdxIfNeeded(Object object) {
        if (object instanceof PdxInstance) {
            object = ((PdxInstance)object).getObject();
        } else if (object instanceof PdxString) {
            object = object.toString();
        }
        return object;
    }

    @Override
    public boolean add(Object e) {
        return this.results.add(e);
    }

    @Override
    public boolean addAll(Collection c) {
        return this.results.addAll(c);
    }

    @Override
    public void clear() {
        this.results.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.results.contains(o);
    }

    @Override
    public boolean containsAll(Collection c) {
        return this.results.containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.results.isEmpty();
    }

    @Override
    public boolean remove(Object o) {
        return this.results.remove(o);
    }

    @Override
    public boolean removeAll(Collection c) {
        return this.results.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection c) {
        return this.results.retainAll(c);
    }

    @Override
    public int size() {
        return this.results.size();
    }

    @Override
    public Object[] toArray() {
        ArrayList arrayList = new ArrayList();
        for (Object o : this) {
            arrayList.add(o);
        }
        return arrayList.toArray();
    }

    @Override
    public Object[] toArray(Object[] a) {
        Iterator iter = this.iterator();
        int i = 0;
        while (iter.hasNext()) {
            a[i++] = iter.next();
        }
        return a;
    }

    @Override
    public boolean isModifiable() {
        return this.results.isModifiable();
    }

    public int occurrences(Object element) {
        return this.results.occurrences(element);
    }

    public Set asSet() {
        return new HashSet(this);
    }

    public List asList() {
        return new ArrayList(this);
    }

    @Override
    public CollectionType getCollectionType() {
        return this.results.getCollectionType();
    }

    @Override
    public void setElementType(ObjectType elementType) {
        this.results.setElementType(elementType);
    }

    private class SelectResultsPdxInstanceIterator
    implements Iterator {
        Iterator iterator;

        SelectResultsPdxInstanceIterator(Iterator iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            Object object = this.iterator.next();
            if (object instanceof Struct) {
                Struct struct = (Struct)object;
                Object[] values = struct.getFieldValues();
                Object[] newValues = new Object[values.length];
                for (int i = 0; i < values.length; ++i) {
                    newValues[i] = values[i] instanceof PdxInstance ? ((PdxInstance)values[i]).getObject() : (values[i] instanceof PdxString ? values[i].toString() : (ResultsCollectionPdxDeserializerWrapper.this.copyOnRead ? ResultsCollectionPdxDeserializerWrapper.this.extractPdxIfNeeded(CopyHelper.copy(values[i])) : values[i]));
                }
                return new StructImpl((StructTypeImpl)struct.getStructType(), newValues);
            }
            if (object instanceof PdxInstance) {
                object = ((PdxInstance)object).getObject();
            } else if (object instanceof PdxString) {
                object = object.toString();
            } else if (ResultsCollectionPdxDeserializerWrapper.this.copyOnRead) {
                object = ResultsCollectionPdxDeserializerWrapper.this.extractPdxIfNeeded(CopyHelper.copy(object));
            }
            return object;
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

