/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.geode.cache.query.FunctionDomainException;
import org.apache.geode.cache.query.NameResolutionException;
import org.apache.geode.cache.query.QueryInvocationTargetException;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.Struct;
import org.apache.geode.cache.query.TypeMismatchException;
import org.apache.geode.cache.query.internal.AbstractCompiledValue;
import org.apache.geode.cache.query.internal.CompiledComparison;
import org.apache.geode.cache.query.internal.CompiledIn;
import org.apache.geode.cache.query.internal.CompiledJunction;
import org.apache.geode.cache.query.internal.CompiledValue;
import org.apache.geode.cache.query.internal.DefaultQuery;
import org.apache.geode.cache.query.internal.ExecutionContext;
import org.apache.geode.cache.query.internal.Filter;
import org.apache.geode.cache.query.internal.GroupJunction;
import org.apache.geode.cache.query.internal.OrganizedOperands;
import org.apache.geode.cache.query.internal.QueryObserver;
import org.apache.geode.cache.query.internal.QueryObserverHolder;
import org.apache.geode.cache.query.internal.QueryUtils;
import org.apache.geode.cache.query.internal.RuntimeIterator;
import org.apache.geode.cache.query.internal.Support;
import org.apache.geode.cache.query.internal.parse.OQLLexerTokenTypes;
import org.apache.geode.cache.query.internal.types.StructTypeImpl;
import org.apache.geode.cache.query.types.ObjectType;
import org.apache.geode.internal.Assert;

public abstract class AbstractGroupOrRangeJunction
extends AbstractCompiledValue
implements Filter,
OQLLexerTokenTypes {
    final CompiledValue[] _operands;
    private static final int INDEX_RESULT_THRESHOLD_DEFAULT = 100;
    public static final String INDX_THRESHOLD_PROP_STR = "gemfire.Query.INDEX_THRESHOLD_SIZE";
    private static final int indexThresholdSize = Integer.getInteger("gemfire.Query.INDEX_THRESHOLD_SIZE", 100);
    private int _operator = 0;
    private CompiledValue iterOperands;
    private RuntimeIterator[] indpndntItr = null;
    private boolean completeExpansion = false;

    AbstractGroupOrRangeJunction(int operator, RuntimeIterator[] indpndntItr, boolean isCompleteExpansion, CompiledValue[] operands) {
        this.indpndntItr = indpndntItr;
        this._operator = operator;
        this.completeExpansion = isCompleteExpansion;
        this._operands = operands;
    }

    AbstractGroupOrRangeJunction(AbstractGroupOrRangeJunction oldGJ, boolean completeExpansion, RuntimeIterator[] indpnds, CompiledValue iterOp) {
        this._operator = oldGJ._operator;
        this.completeExpansion = completeExpansion;
        this.indpndntItr = indpnds;
        if (iterOp != null) {
            if (iterOp instanceof CompiledComparison || iterOp instanceof CompiledIn) {
                int finalSize = 1 + oldGJ._operands.length;
                this._operands = new CompiledValue[finalSize];
                System.arraycopy(oldGJ._operands, 0, this._operands, 0, finalSize - 1);
                this._operands[finalSize - 1] = iterOp;
            } else {
                CompiledJunction temp = (CompiledJunction)iterOp;
                int operator = temp.getOperator();
                if (this._operator == operator) {
                    int tempOpSize = temp.getOperands().size();
                    int oldGJOpSize = oldGJ._operands.length;
                    this._operands = new CompiledValue[tempOpSize + oldGJOpSize];
                    System.arraycopy(oldGJ._operands, 0, this._operands, 0, oldGJOpSize);
                    Iterator<CompiledValue> itr = temp.getOperands().iterator();
                    int i = oldGJOpSize;
                    while (itr.hasNext()) {
                        this._operands[i++] = itr.next();
                    }
                } else {
                    int oldGJOpSize = oldGJ._operands.length;
                    this._operands = new CompiledValue[1 + oldGJOpSize];
                    System.arraycopy(oldGJ._operands, 0, this._operands, 0, oldGJOpSize);
                    this._operands[oldGJOpSize] = temp;
                }
            }
        } else {
            this._operands = oldGJ._operands;
        }
    }

    @Override
    public Object evaluate(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        throw new AssertionError((Object)"Should not have come here");
    }

    @Override
    public int getType() {
        return -7;
    }

    void setCompleteExpansionOn() {
        this.completeExpansion = true;
    }

    void addIterOperands(CompiledValue iterOps) {
        this.iterOperands = iterOps;
    }

    CompiledValue getIterOperands() {
        return this.iterOperands;
    }

    @Override
    public SelectResults filterEvaluate(ExecutionContext context, SelectResults iterationLimit, boolean completeExpansionNeeded, CompiledValue iterOperands, RuntimeIterator[] indpndntItrs, boolean isIntersection, boolean conditioningNeeded, boolean evalProj) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        if (iterOperands != null) {
            this.addIterOperands(iterOperands);
        }
        return this.filterEvaluate(context, null);
    }

    @Override
    public SelectResults filterEvaluate(ExecutionContext context, SelectResults intermediateResults) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        OrganizedOperands newOperands = this.organizeOperands(context);
        SelectResults result = intermediateResults;
        Support.Assert(newOperands.filterOperand != null);
        if (newOperands.isSingleFilter) {
            result = newOperands.filterOperand.filterEvaluate(context, result, this.completeExpansion, newOperands.iterateOperand, this.indpndntItr, true, newOperands.filterOperand.isConditioningNeededForIndex(this.indpndntItr.length == 1 ? this.indpndntItr[0] : null, context, this.completeExpansion), true);
        } else {
            assert (newOperands.filterOperand instanceof GroupJunction);
            result = newOperands.filterOperand.auxFilterEvaluate(context, result);
            List unevaluatedFilterOps = ((GroupJunction)newOperands.filterOperand).getUnevaluatedFilterOperands();
            if (unevaluatedFilterOps != null) {
                if (newOperands.iterateOperand == null) {
                    if (unevaluatedFilterOps.size() == 1) {
                        newOperands.iterateOperand = (CompiledValue)unevaluatedFilterOps.get(0);
                    } else {
                        int len = unevaluatedFilterOps.size();
                        CompiledValue[] iterOps = new CompiledValue[len];
                        for (int i = 0; i < len; ++i) {
                            iterOps[i] = (CompiledValue)unevaluatedFilterOps.get(i);
                        }
                        newOperands.iterateOperand = new CompiledJunction(iterOps, this.getOperator());
                    }
                } else {
                    if (newOperands.iterateOperand instanceof CompiledJunction && ((CompiledJunction)newOperands.iterateOperand).getOperator() == this.getOperator()) {
                        CompiledJunction temp = (CompiledJunction)newOperands.iterateOperand;
                        List<CompiledValue> prevOps = temp.getOperands();
                        unevaluatedFilterOps.addAll(prevOps);
                    } else {
                        unevaluatedFilterOps.add(newOperands.iterateOperand);
                    }
                    int totalLen = unevaluatedFilterOps.size();
                    CompiledValue[] combinedOps = new CompiledValue[totalLen];
                    Iterator itr = unevaluatedFilterOps.iterator();
                    int j = 0;
                    while (itr.hasNext()) {
                        combinedOps[j++] = (CompiledValue)itr.next();
                    }
                    newOperands.iterateOperand = new CompiledJunction(combinedOps, this.getOperator());
                }
            }
            if (newOperands.iterateOperand != null) {
                result = this.auxIterateEvaluate(newOperands.iterateOperand, context, result);
            }
        }
        return result;
    }

    private List getCondtionsSortedOnIncreasingEstimatedIndexResultSize(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        ArrayList<Filter> sortedList = new ArrayList<Filter>(this._operands.length);
        int len = this._operands.length;
        for (CompiledValue operand : this._operands) {
            Filter currSorted;
            int j;
            Filter toSort = (Filter)((Object)operand);
            int indxRsltToSort = toSort.getSizeEstimate(context);
            int sortedListLen = sortedList.size();
            for (j = 0; j < sortedListLen && (currSorted = (Filter)sortedList.get(j)).getSizeEstimate(context) <= indxRsltToSort; ++j) {
            }
            sortedList.add(j, toSort);
        }
        return sortedList;
    }

    @Override
    public SelectResults auxFilterEvaluate(ExecutionContext context, SelectResults intermediateResults) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        List sortedConditionsList = this.getCondtionsSortedOnIncreasingEstimatedIndexResultSize(context);
        Iterator i = sortedConditionsList.iterator();
        while (i.hasNext()) {
            boolean isDistinct;
            SelectResults filterResults = null;
            Filter filter = (Filter)i.next();
            boolean isConditioningNeeded = filter.isConditioningNeededForIndex(this.indpndntItr.length == 1 ? this.indpndntItr[0] : null, context, this.completeExpansion);
            filterResults = filter.filterEvaluate(context, !isConditioningNeeded ? intermediateResults : null, this.completeExpansion, null, this.indpndntItr, this._operator == 91, isConditioningNeeded, false);
            if (this._operator == 91) {
                if (filterResults != null && filterResults.isEmpty()) {
                    return filterResults;
                }
                if (filterResults == null) continue;
                intermediateResults = intermediateResults == null || !isConditioningNeeded ? filterResults : QueryUtils.intersection(intermediateResults, filterResults, context);
                i.remove();
                if (intermediateResults.size() > indexThresholdSize) continue;
                break;
            }
            Assert.assertTrue(filterResults != null);
            boolean bl = isDistinct = context.getQuery() != null && ((DefaultQuery)context.getQuery()).getSelect().isDistinct();
            if (intermediateResults == null) {
                intermediateResults = filterResults;
                continue;
            }
            if (isDistinct && !isConditioningNeeded) {
                intermediateResults.addAll(filterResults);
                continue;
            }
            intermediateResults = QueryUtils.union(intermediateResults, filterResults, context);
        }
        if (this._operator == 91 && !sortedConditionsList.isEmpty()) {
            this.addUnevaluatedFilterOperands(sortedConditionsList);
        }
        return intermediateResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SelectResults auxIterateEvaluate(CompiledValue operand, ExecutionContext context, SelectResults intermediateResults) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        if (intermediateResults == null) {
            throw new RuntimeException("intermediateResults can not be null");
        }
        if (intermediateResults.isEmpty()) {
            return intermediateResults;
        }
        List currentIters = this.completeExpansion ? context.getCurrentIterators() : QueryUtils.getDependentItrChainForIndpndntItrs(this.indpndntItr, context);
        SelectResults resultSet = null;
        RuntimeIterator[] rIters = new RuntimeIterator[currentIters.size()];
        currentIters.toArray(rIters);
        ObjectType elementType = intermediateResults.getCollectionType().getElementType();
        resultSet = elementType.isStructType() ? QueryUtils.createStructCollection(context, (StructTypeImpl)elementType) : QueryUtils.createResultCollection(context, elementType);
        QueryObserver observer = QueryObserverHolder.getInstance();
        try {
            observer.startIteration(intermediateResults, operand);
            for (Object tuple : intermediateResults) {
                if (tuple instanceof Struct) {
                    Object[] values = ((Struct)tuple).getFieldValues();
                    for (int i = 0; i < values.length; ++i) {
                        rIters[i].setCurrent(values[i]);
                    }
                } else {
                    rIters[0].setCurrent(tuple);
                }
                Object result = null;
                try {
                    result = operand.evaluate(context);
                }
                finally {
                    observer.afterIterationEvaluation(result);
                }
                if (result instanceof Boolean) {
                    if (!((Boolean)result).booleanValue()) continue;
                    resultSet.add(tuple);
                    continue;
                }
                if (result == null || result == QueryService.UNDEFINED) continue;
                throw new TypeMismatchException("AND/OR operands must be of type boolean, not type '" + result.getClass().getName() + "'");
            }
        }
        finally {
            observer.endIteration(resultSet);
        }
        return resultSet;
    }

    @Override
    public int getOperator() {
        return this._operator;
    }

    List getOperands() {
        return Collections.unmodifiableList(Arrays.asList(this._operands));
    }

    boolean getExpansionFlag() {
        return this.completeExpansion;
    }

    RuntimeIterator[] getIndependentIteratorForGroup() {
        return this.indpndntItr;
    }

    OrganizedOperands createOrganizedOperandsObject(int indexCount, List evalOperands) {
        OrganizedOperands result = new OrganizedOperands();
        Filter filterOperands = null;
        Support.Assert(indexCount > 0);
        if (indexCount == 1) {
            filterOperands = (Filter)evalOperands.get(0);
            result.isSingleFilter = true;
        } else {
            CompiledValue[] newOperands = new CompiledValue[indexCount];
            for (int i = 0; i < indexCount; ++i) {
                newOperands[i] = (CompiledValue)evalOperands.get(i);
            }
            filterOperands = new GroupJunction(this.getOperator(), this.getIndependentIteratorForGroup(), this.getExpansionFlag(), newOperands);
        }
        CompiledValue iterateOperands = null;
        int numIterating = evalOperands.size() - indexCount;
        if (numIterating > 0) {
            if (numIterating == 1) {
                iterateOperands = (CompiledValue)evalOperands.get(indexCount);
            } else {
                CompiledValue[] newOperands = new CompiledValue[numIterating];
                for (int i = 0; i < numIterating; ++i) {
                    newOperands[i] = (CompiledValue)evalOperands.get(i + indexCount);
                }
                iterateOperands = new CompiledJunction(newOperands, this.getOperator());
            }
        }
        result.filterOperand = filterOperands;
        result.iterateOperand = iterateOperands;
        return result;
    }

    abstract AbstractGroupOrRangeJunction recreateFromOld(boolean var1, RuntimeIterator[] var2, CompiledValue var3);

    abstract AbstractGroupOrRangeJunction createNewOfSameType(int var1, RuntimeIterator[] var2, boolean var3, CompiledValue[] var4);

    abstract OrganizedOperands organizeOperands(ExecutionContext var1) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException;

    abstract void addUnevaluatedFilterOperands(List var1);
}

