/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal.xml;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.apache.geode.InternalGemFireException;
import org.apache.geode.SerializationException;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.Region;
import org.apache.geode.connectors.jdbc.JdbcConnectorException;
import org.apache.geode.connectors.jdbc.internal.JdbcConnectorService;
import org.apache.geode.connectors.jdbc.internal.RegionMappingExistsException;
import org.apache.geode.connectors.jdbc.internal.TableMetaDataManager;
import org.apache.geode.connectors.jdbc.internal.TableMetaDataView;
import org.apache.geode.connectors.jdbc.internal.configuration.FieldMapping;
import org.apache.geode.connectors.jdbc.internal.configuration.RegionMapping;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.extension.Extensible;
import org.apache.geode.internal.cache.extension.Extension;
import org.apache.geode.internal.cache.extension.ExtensionPoint;
import org.apache.geode.internal.cache.xmlcache.XmlGenerator;
import org.apache.geode.internal.classloader.ClassPathLoader;
import org.apache.geode.internal.jndi.JNDIInvoker;
import org.apache.geode.pdx.PdxWriter;
import org.apache.geode.pdx.ReflectionBasedAutoSerializer;
import org.apache.geode.pdx.internal.PdxOutputStream;
import org.apache.geode.pdx.internal.PdxType;
import org.apache.geode.pdx.internal.PdxWriterImpl;
import org.apache.geode.pdx.internal.TypeRegistry;

public class RegionMappingConfiguration
implements Extension<Region<?, ?>> {
    private final RegionMapping mapping;

    public RegionMappingConfiguration(RegionMapping mapping) {
        this.mapping = mapping;
    }

    public XmlGenerator<Region<?, ?>> getXmlGenerator() {
        return null;
    }

    public void beforeCreate(Extensible<Region<?, ?>> source, Cache cache) {
    }

    public void onCreate(Extensible<Region<?, ?>> source, Extensible<Region<?, ?>> target) {
        ExtensionPoint extensionPoint = target.getExtensionPoint();
        Region region = (Region)extensionPoint.getTarget();
        InternalCache internalCache = (InternalCache)region.getRegionService();
        JdbcConnectorService service = (JdbcConnectorService)internalCache.getService(JdbcConnectorService.class);
        if (this.mapping.getFieldMappings().isEmpty()) {
            Class<?> pdxClazz = this.loadPdxClass(this.mapping.getPdxName());
            PdxType pdxType = this.getPdxTypeForClass((Cache)internalCache, pdxClazz);
            List<FieldMapping> fieldMappings = this.createDefaultFieldMapping(service, pdxType);
            fieldMappings.forEach(this.mapping::addFieldMapping);
        }
        service.validateMapping(this.mapping);
        this.createRegionMapping(service, this.mapping);
    }

    private void createRegionMapping(JdbcConnectorService service, RegionMapping regionMapping) {
        try {
            service.createRegionMapping(regionMapping);
        }
        catch (RegionMappingExistsException e) {
            throw new InternalGemFireException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    List<FieldMapping> createDefaultFieldMapping(JdbcConnectorService service, PdxType pdxType) {
        DataSource dataSource = this.getDataSource(this.mapping.getDataSourceName());
        if (dataSource == null) {
            throw new JdbcConnectorException("No datasource \"" + this.mapping.getDataSourceName() + "\" found when creating default field mapping");
        }
        TableMetaDataManager manager = this.getTableMetaDataManager();
        try (Connection connection = dataSource.getConnection();){
            TableMetaDataView tableMetaData = manager.getTableMetaDataView(connection, this.mapping);
            List<FieldMapping> list = service.createFieldMappingUsingPdx(pdxType, tableMetaData);
            return list;
        }
        catch (SQLException e) {
            throw JdbcConnectorException.createException(e);
        }
    }

    protected PdxType getPdxTypeForClass(Cache cache, Class<?> clazz) {
        InternalCache internalCache = (InternalCache)cache;
        TypeRegistry typeRegistry = internalCache.getPdxRegistry();
        PdxType result = typeRegistry.getExistingTypeForClass(clazz);
        if (result != null) {
            return result;
        }
        return this.generatePdxTypeForClass(internalCache, typeRegistry, clazz);
    }

    PdxType generatePdxTypeForClass(InternalCache cache, TypeRegistry typeRegistry, Class<?> clazz) {
        block2: {
            Object object = this.createInstance(clazz);
            try {
                cache.registerPdxMetaData(object);
            }
            catch (SerializationException ex) {
                String className = clazz.getName();
                ReflectionBasedAutoSerializer serializer = this.getReflectionBasedAutoSerializer("\\Q" + className + "\\E");
                PdxWriter writer = this.createPdxWriter(typeRegistry, object);
                boolean result = serializer.toData(object, writer);
                if (result) break block2;
                throw new JdbcConnectorException("Could not generate a PdxType using the ReflectionBasedAutoSerializer for the class  " + clazz.getName() + " after failing to register pdx metadata due to " + ex.getMessage() + ". Check the server log for details.");
            }
        }
        return typeRegistry.getExistingTypeForClass(clazz);
    }

    private Object createInstance(Class<?> clazz) {
        try {
            Constructor<?> ctor = clazz.getConstructor(new Class[0]);
            return ctor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new JdbcConnectorException("Could not generate a PdxType for the class " + clazz.getName() + " because it did not have a public zero arg constructor. Details: " + ex);
        }
    }

    private Class<?> loadPdxClass(String className) {
        try {
            return ClassPathLoader.getLatest().forName(className);
        }
        catch (ClassNotFoundException ex) {
            throw new JdbcConnectorException("The pdx class \"" + className + "\" could not be loaded because: " + ex);
        }
    }

    DataSource getDataSource(String dataSourceName) {
        return JNDIInvoker.getDataSource((String)dataSourceName);
    }

    ReflectionBasedAutoSerializer getReflectionBasedAutoSerializer(String className) {
        return new ReflectionBasedAutoSerializer(new String[]{className});
    }

    PdxWriter createPdxWriter(TypeRegistry typeRegistry, Object object) {
        return new PdxWriterImpl(typeRegistry, object, new PdxOutputStream());
    }

    TableMetaDataManager getTableMetaDataManager() {
        return new TableMetaDataManager();
    }
}

