/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.rmiio;

import java.io.IOException;
import java.io.InputStream;

public abstract class PacketInputStream
extends InputStream {
    public static final int DEFAULT_PACKET_SIZE = 1024;
    protected static final byte[] EMPTY_PACKET = new byte[0];
    private final int _packetSize;
    private final boolean _noDelay;

    public PacketInputStream() {
        this(1024);
    }

    public PacketInputStream(int packetSize) {
        this(packetSize, false);
    }

    public PacketInputStream(int packetSize, boolean noDelay) {
        this._packetSize = packetSize;
        this._noDelay = noDelay;
    }

    public int getPacketSize() {
        return this._packetSize;
    }

    public boolean getNoDelay() {
        return this._noDelay;
    }

    public byte[] readPacket() throws IOException {
        return this.readPacket(this._noDelay);
    }

    public abstract byte[] readPacket(boolean var1) throws IOException;

    public abstract int packetsAvailable() throws IOException;

    public static byte[] readPacket(InputStream in, byte[] packet) throws IOException {
        int readLen = in.read(packet, 0, packet.length);
        if (readLen > 0) {
            if (readLen < packet.length) {
                byte[] tmpPacket = new byte[readLen];
                System.arraycopy(packet, 0, tmpPacket, 0, readLen);
                packet = tmpPacket;
            }
            return packet;
        }
        if (readLen == 0) {
            return EMPTY_PACKET;
        }
        return null;
    }
}

