# Apache Geode Native Client User Guides

This document contains instructions for building and viewing the Apache Geode Native Client User Guides.

<a name="about"></a>
## About

The Geode-Native repository provides the full source for the Apache Geode Native Client User Guides in markdown format (see _geode-project-dir_/geode-docs/CONTRIBUTE.md for more information on how to use markdown in this context). Users can build the markdown into an HTML user guide using [Bookbinder](https://github.com/pivotal-cf/bookbinder) and the instructions below.

Bookbinder is a Ruby gem (available at [rubygems.org](https://rubygems.org/gems/bookbindery/) ) that binds a unified documentation web application from markdown, html, and/or DITA source material. The source material for Bookbinder must be stored either in local directories or in GitHub repositories. Bookbinder runs [Middleman](http://middlemanapp.com/) to produce a Rackup app that can be deployed locally or as a web application.

The User Guide can be produced in two versions: one for the .NET native client, the other for the C++ native client.

## Preview the User Guide

Documentation can be built and previewed using the utility script at {geode-project-dir}/docs/docker. This script uses a Docker image that provides the tools to build and view the guide, including Ruby, Bookbinder, and Rackup.

For C++ guide:
```
$ cd {geode-native-project-dir}/docs/docker
$ ./preview-user-guide.sh cpp
```

For .NET guide:
```
$ cd {geode-native-project-dir}/docs/docker
$ ./preview-user-guide.sh dotnet
```

In a browser, navigate to `http://localhost:9292` to view the user guide.


## Build the User Guide

### Prerequisites

Bookbinder requires Ruby version 2.3.3 or higher.

### Bookbinder Usage

Bookbinder is meant to be used from within a project called a **book**. The book includes a configuration file that describes which documentation repositories to use as source materials. Bookbinder provides a set of scripts to aggregate those repositories and publish them to various locations.

For Geode Native Client, a preconfigured **book** is provided for each user guide (C++ and .NET) in the directories `{geode-native-project-dir}/docs/geode-native-book-cpp` and `{geode-native-project-dir}/docs/geode-native-book-dotnet`. Each book gathers content from the language-specific directory _geode-native-project-dir_/docs/geode-native-docs-cpp or geode-native-docs-dotnet. You can use this configuration to build an HTML version of the Apache Geode Native Client User Guides on your local system.

### Building the Documentation

1. The GemFile in each book directory already defines the gem "bookbindery" dependency. Make sure you are in the `_geode-native-project-dir_/docs/geode-native-book-cpp` or `_geode-native-project-dir_/docs/geode-native-book-dotnet` (depending if you want to build the C++ or .NET user guide respectively) directory and enter:

   For C++ guide:
    
   ```bash
   $ cd docs/geode-native-book-cpp
   $ bundle install
   ```

   For .NET guide:
    
   ```bash
   $ cd docs/geode-native-book-dotnet
   $ bundle install
   ```

   Note: You will not have to run bundle install on subsequent builds.

2. To build the documentation locally using the installed config.yml file, enter:

   ```
   $ bundle exec bookbinder bind local
   ```
   
   Bookbinder converts the markdown source into HTML, which it puts in the `final_app` directory.

3. To start a local website of the Apache Geode Native Client User Guide, you have to execute Rackup from the `final_app` directory:

   For C++ guide:
    
   ```bash
   $ cd docs/geode-native-book-cpp/final_app
   $ bundle exec rackup
   ```

   For .NET guide:
    
   ```bash
   $ cd docs/geode-native-book-dotnet/final_app
   $ bundle exec rackup
   ```

   You can now view the local documentation at `http://localhost:9292`.
