/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.pubsub;

import io.netty.channel.ChannelFuture;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.CountDownLatch;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.redis.internal.executor.RedisResponse;
import org.apache.geode.redis.internal.netty.Client;
import org.apache.geode.redis.internal.netty.ExecutionHandlerContext;
import org.apache.geode.redis.internal.pubsub.PublishResultCollector;
import org.apache.geode.redis.internal.pubsub.Subscription;
import org.apache.geode.redis.internal.pubsub.Subscriptions;
import org.apache.logging.log4j.Logger;

public abstract class AbstractSubscription
implements Subscription {
    private static final Logger logger = LogService.getLogger();
    private final Client client;
    private final ExecutionHandlerContext context;
    private final CountDownLatch readyForPublish = new CountDownLatch(1);
    private final Subscriptions subscriptions;
    private boolean running = true;

    AbstractSubscription(Client client, ExecutionHandlerContext context, Subscriptions subscriptions) {
        if (client == null) {
            throw new IllegalArgumentException("client cannot be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("context cannot be null");
        }
        if (subscriptions == null) {
            throw new IllegalArgumentException("subscriptions cannot be null");
        }
        this.client = client;
        this.context = context;
        this.subscriptions = subscriptions;
        client.addShutdownListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener)future -> this.shutdown()));
    }

    @Override
    public void readyToPublish() {
        this.readyForPublish.countDown();
    }

    @Override
    public void publishMessage(byte[] channel, byte[] message, PublishResultCollector publishResultCollector) {
        try {
            this.readyForPublish.await();
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            this.running = false;
        }
        if (this.running) {
            this.writeToChannel(this.constructResponse(channel, message), publishResultCollector);
        } else {
            publishResultCollector.failure(this.client);
        }
    }

    @Override
    public synchronized void shutdown() {
        this.running = false;
        this.subscriptions.remove(this.client);
        this.readyToPublish();
    }

    public Client getClient() {
        return this.client;
    }

    @Override
    public boolean matchesClient(Client client) {
        return this.client.equals(client);
    }

    private RedisResponse constructResponse(byte[] channel, byte[] message) {
        return RedisResponse.array(this.createResponse(channel, message));
    }

    private void writeToChannel(RedisResponse response, PublishResultCollector resultCollector) {
        ChannelFuture result = this.context.writeToChannel(response).syncUninterruptibly();
        if (result.cause() == null) {
            resultCollector.success();
        } else {
            resultCollector.failure(this.client);
        }
    }
}

