/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.string;

import java.util.List;
import org.apache.geode.redis.internal.data.RedisKey;
import org.apache.geode.redis.internal.executor.RedisResponse;
import org.apache.geode.redis.internal.executor.string.RedisStringCommands;
import org.apache.geode.redis.internal.executor.string.StringExecutor;
import org.apache.geode.redis.internal.netty.Coder;
import org.apache.geode.redis.internal.netty.Command;
import org.apache.geode.redis.internal.netty.ExecutionHandlerContext;

public class SetRangeExecutor
extends StringExecutor {
    private static final String ERROR_NOT_INT = "The number provided must be numeric";
    private static final String ERROR_ILLEGAL_OFFSET = "The offset is out of range, must be greater than or equal to 0 and the offset added to the length of the value must be less than 536870911 (512MB), the maximum allowed size";

    @Override
    public RedisResponse executeCommand(Command command, ExecutionHandlerContext context) {
        int offset;
        List<byte[]> commandElems = command.getProcessedCommand();
        RedisKey key = command.getKey();
        try {
            byte[] offAr = commandElems.get(2);
            offset = Coder.bytesToInt(offAr);
        }
        catch (NumberFormatException e) {
            return RedisResponse.error(ERROR_NOT_INT);
        }
        byte[] value = commandElems.get(3);
        if (offset < 0 || offset + value.length > 0x1FFFFFFF) {
            return RedisResponse.error(ERROR_ILLEGAL_OFFSET);
        }
        RedisStringCommands stringCommands = this.getRedisStringCommands(context);
        int result = stringCommands.setrange(key, offset, value);
        return RedisResponse.integer(result);
    }
}

