/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.connection;

import java.util.Arrays;
import java.util.List;
import org.apache.geode.redis.internal.executor.AbstractExecutor;
import org.apache.geode.redis.internal.executor.RedisResponse;
import org.apache.geode.redis.internal.netty.Command;
import org.apache.geode.redis.internal.netty.ExecutionHandlerContext;

public class PingExecutor
extends AbstractExecutor {
    private final String PING_RESPONSE = "PONG";

    @Override
    public RedisResponse executeCommand(Command command, ExecutionHandlerContext context) {
        RedisResponse redisResponse;
        List<byte[]> commandElems = command.getProcessedCommand();
        context.eventLoopReady();
        if (context.getPubSub().findSubscriptionNames(context.getClient()).isEmpty()) {
            byte[] result = commandElems.size() > 1 ? commandElems.get(1) : "PONG".getBytes();
            redisResponse = RedisResponse.string(result);
        } else {
            byte[] result = commandElems.size() > 1 ? commandElems.get(1) : "".getBytes();
            redisResponse = RedisResponse.array(Arrays.asList("PONG".toLowerCase().getBytes(), result));
        }
        return redisResponse;
    }
}

