/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.cluster;

public class CRC16 {
    private static final int CCITT_POLY = 33800;
    private static final short[] crcTable = new short[256];

    public static int calculate(byte[] data, int start, int end) {
        int crc = 0;
        for (int i = start; i < end; ++i) {
            crc = crc << 8 & 0xFF00 ^ crcTable[crc >> 8 ^ data[i] & 0xFF] & 0xFFFF;
        }
        return crc;
    }

    public static int calculate(String data) {
        byte[] bytes = data.getBytes();
        return CRC16.calculate(bytes, 0, bytes.length);
    }

    private static int reverseInt16(int i) {
        i = (i & 0x5555) << 1 | i >>> 1 & 0x5555;
        i = (i & 0x3333) << 2 | i >>> 2 & 0x3333;
        i = (i & 0xF0F) << 4 | i >>> 4 & 0xF0F;
        i = (i & 0xFF) << 8 | i >>> 8;
        return i;
    }

    static {
        int poly = CRC16.reverseInt16(33800);
        for (int x = 0; x < 256; ++x) {
            int w = x << 8;
            for (int i = 0; i < 8; ++i) {
                if ((w & 0x8000) != 0) {
                    w = w << 1 ^ poly;
                    continue;
                }
                w <<= 1;
            }
            CRC16.crcTable[x] = (short)w;
        }
    }
}

