/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor;

import java.util.concurrent.Callable;
import org.apache.geode.redis.internal.executor.StripedExecutor;

public class SynchronizedStripedExecutor
implements StripedExecutor {
    private static final int DEFAULT_CONCURRENCY_LEVEL = 4093;
    private final Object[] syncs;

    public SynchronizedStripedExecutor() {
        this(4093);
    }

    public SynchronizedStripedExecutor(int concurrencyLevel) {
        this.syncs = new Object[concurrencyLevel];
        for (int i = 0; i < concurrencyLevel; ++i) {
            this.syncs[i] = new Object();
        }
    }

    @Override
    public <T> T execute(Object stripeId, Callable<T> callable) {
        Object object = this.getSync(stripeId);
        synchronized (object) {
            try {
                return callable.call();
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private Object getSync(Object stripeId) {
        return this.syncs[this.getStripeIndex(stripeId)];
    }

    private int getStripeIndex(Object stripeId) {
        int hash = stripeId.hashCode();
        if (hash < 0) {
            hash = -hash;
        }
        return hash % this.syncs.length;
    }

    @Override
    public int compareStripes(Object object1, Object object2) {
        return this.getStripeIndex(object1) - this.getStripeIndex(object2);
    }
}

