/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.Collections;
import java.util.List;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.lang.ClassUtils;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.cli.domain.DiskStoreDetails;
import org.apache.geode.management.internal.cli.functions.DescribeDiskStoreFunction;
import org.apache.geode.management.internal.cli.result.model.DataResultModel;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.result.model.TabularResultModel;
import org.apache.geode.management.internal.exceptions.EntityNotFoundException;
import org.apache.geode.management.internal.i18n.CliStrings;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class DescribeDiskStoreCommand
extends GfshCommand {
    public static final String DISK_STORE_SECTION = "disk-store";
    public static final String DISK_DIR_SECTION = "disk-dir";
    public static final String REGION_SECTION = "region";
    public static final String CACHE_SERVER_SECTION = "cache-server";
    public static final String GATEWAY_SECTION = "gateway";
    public static final String ASYNC_EVENT_QUEUE_SECTION = "async-event-queue";

    @CliCommand(value={"describe disk-store"}, help="Display information about a member's disk store.")
    @CliMetaData(relatedTopic={"Disk Store"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public ResultModel describeDiskStore(@CliOption(key={"member"}, mandatory=true, optionContext="geode.converter.member.idOrName:disable-string-converter", help="Name/Id of the member with the disk store to be described.") String memberName, @CliOption(key={"name"}, mandatory=true, optionContext="geode.converter.cluster.diskstore:disable-string-converter", help="Name of the disk store to be described.") String diskStoreName) {
        return this.toResultModel(this.getDiskStoreDescription(memberName, diskStoreName));
    }

    DiskStoreDetails getDiskStoreDescription(String memberName, String diskStoreName) {
        DistributedMember member = this.getMember(memberName);
        ResultCollector resultCollector = this.getMembersFunctionExecutor(Collections.singleton(member)).setArguments((Object)diskStoreName).execute((Function)new DescribeDiskStoreFunction());
        Object result = ((List)resultCollector.getResult()).get(0);
        if (result instanceof DiskStoreDetails) {
            return (DiskStoreDetails)result;
        }
        if (result instanceof EntityNotFoundException) {
            throw (EntityNotFoundException)result;
        }
        Throwable cause = result instanceof Throwable ? (Throwable)result : null;
        throw new RuntimeException(CliStrings.format((String)"Received an unexpected return type ({0}) while executing command {1}.", (Object[])new Object[]{ClassUtils.getClassName(result), "describe disk-store"}), cause);
    }

    private ResultModel toResultModel(DiskStoreDetails diskStoreDetails) {
        ResultModel result = new ResultModel();
        DataResultModel diskStoreSection = result.addData(DISK_STORE_SECTION);
        diskStoreSection.addData("Disk Store ID", diskStoreDetails.getId());
        diskStoreSection.addData("Disk Store Name", diskStoreDetails.getName());
        diskStoreSection.addData("Member ID", diskStoreDetails.getMemberId());
        diskStoreSection.addData("Member Name", diskStoreDetails.getMemberName());
        diskStoreSection.addData("Allow Force Compaction", diskStoreDetails.isAllowForceCompaction() ? "Yes" : "No");
        diskStoreSection.addData("Auto Compaction", diskStoreDetails.isAutoCompact() ? "Yes" : "No");
        diskStoreSection.addData("Compaction Threshold", diskStoreDetails.getCompactionThreshold());
        diskStoreSection.addData("Max Oplog Size", diskStoreDetails.getMaxOplogSize());
        diskStoreSection.addData("Queue Size", diskStoreDetails.getQueueSize());
        diskStoreSection.addData("Time Interval", diskStoreDetails.getTimeInterval());
        diskStoreSection.addData("Write Buffer Size", diskStoreDetails.getWriteBufferSize());
        diskStoreSection.addData("Disk Usage Warning Percentage", diskStoreDetails.getDiskUsageWarningPercentage());
        diskStoreSection.addData("Disk Usage Critical Percentage", diskStoreDetails.getDiskUsageCriticalPercentage());
        diskStoreSection.addData("PDX Serialization Meta-Data Stored", diskStoreDetails.isPdxSerializationMetaDataStored() ? "Yes" : "No");
        TabularResultModel diskDirTable = result.addTable(DISK_DIR_SECTION);
        for (Object diskDirDetails : diskStoreDetails) {
            diskDirTable.accumulate("Disk Directory", ((DiskStoreDetails.DiskDirDetails)diskDirDetails).getAbsolutePath());
            diskDirTable.accumulate("Size", Integer.toString(((DiskStoreDetails.DiskDirDetails)diskDirDetails).getSize()));
        }
        TabularResultModel regionTable = result.addTable(REGION_SECTION);
        for (DiskStoreDetails.RegionDetails regionDetails : diskStoreDetails.iterateRegions()) {
            regionTable.accumulate("Region Path", regionDetails.getFullPath());
            regionTable.accumulate("Region Name", regionDetails.getName());
            regionTable.accumulate("Persistent", regionDetails.isPersistent() ? "Yes" : "No");
            regionTable.accumulate("Overflow To Disk", regionDetails.isOverflowToDisk() ? "Yes" : "No");
        }
        TabularResultModel cacheServerTable = result.addTable(CACHE_SERVER_SECTION);
        for (DiskStoreDetails.CacheServerDetails cacheServerDetails : diskStoreDetails.iterateCacheServers()) {
            cacheServerTable.accumulate("Bind Address", cacheServerDetails.getBindAddress());
            cacheServerTable.accumulate("Hostname for Clients", cacheServerDetails.getHostName());
            cacheServerTable.accumulate("Port", Integer.toString(cacheServerDetails.getPort()));
        }
        TabularResultModel tabularResultModel = result.addTable(GATEWAY_SECTION);
        for (DiskStoreDetails.GatewayDetails gatewayDetails : diskStoreDetails.iterateGateways()) {
            tabularResultModel.accumulate("Gateway ID", gatewayDetails.getId());
            tabularResultModel.accumulate("Persistent", gatewayDetails.isPersistent() ? "Yes" : "No");
        }
        TabularResultModel tabularResultModel2 = result.addTable(ASYNC_EVENT_QUEUE_SECTION);
        for (DiskStoreDetails.AsyncEventQueueDetails asyncEventQueueDetails : diskStoreDetails.iterateAsyncEventQueues()) {
            tabularResultModel2.accumulate("Async Event Queue ID", asyncEventQueueDetails.getId());
        }
        return result;
    }
}

