/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Collection;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.PhysicalAddress;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.protocols.TP;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.AsciiString;
import org.jgroups.util.SuppressLog;
import org.jgroups.util.Util;

public class UDP
extends TP {
    @Property(description="Traffic class for sending unicast and multicast datagrams. Default is 8")
    protected int tos = 8;
    @Property(name="mcast_addr", description="The multicast address used for sending and receiving packets", defaultValueIPv4="228.8.8.8", defaultValueIPv6="ff0e::8:8:8", systemProperty={"jgroups.udp.mcast_addr"}, writable=false)
    protected InetAddress mcast_group_addr = null;
    @Property(description="The multicast port used for sending and receiving packets. Default is 7600", systemProperty={"jgroups.udp.mcast_port"}, writable=false)
    protected int mcast_port = 7600;
    @Property(description="Multicast toggle. If false multiple unicast datagrams are sent instead of one multicast. Default is true", writable=false)
    protected boolean ip_mcast = true;
    @Property(description="The time-to-live (TTL) for multicast datagram packets. Default is 8", systemProperty={"jgroups.udp.ip_ttl"})
    protected int ip_ttl = 8;
    @Property(description="Send buffer size of the multicast datagram socket. Default is 100'000 bytes")
    protected int mcast_send_buf_size = 100000;
    @Property(description="Receive buffer size of the multicast datagram socket. Default is 500'000 bytes")
    protected int mcast_recv_buf_size = 500000;
    @Property(description="Send buffer size of the unicast datagram socket. Default is 100'000 bytes")
    protected int ucast_send_buf_size = 100000;
    @Property(description="Receive buffer size of the unicast datagram socket. Default is 64'000 bytes")
    protected int ucast_recv_buf_size = 64000;
    @Property(description="If true, disables IP_MULTICAST_LOOP on the MulticastSocket (for sending and receiving of multicast packets). IP multicast packets send on a host P will therefore not be received by anyone on P. Use with caution.")
    protected boolean disable_loopback = false;
    @Property(description="Suppresses warnings on Mac OS (for now) about not enough buffer space when sending a datagram packet")
    protected long suppress_time_out_of_buffer_space = 60000L;
    protected IpAddress mcast_addr;
    protected MulticastSocket sock;
    protected MulticastSocket mcast_sock = null;
    protected PacketReceiver mcast_receiver = null;
    protected PacketReceiver ucast_receiver = null;
    protected SuppressLog<InetAddress> suppress_log_out_of_buffer_space;
    protected static final boolean is_android = Util.checkForAndroid();
    protected static final boolean is_mac = Util.checkForMac();

    @Override
    public boolean supportsMulticasting() {
        return this.ip_mcast;
    }

    public void setMulticastAddress(InetAddress addr) {
        this.mcast_group_addr = addr;
    }

    public InetAddress getMulticastAddress() {
        return this.mcast_group_addr;
    }

    public int getMulticastPort() {
        return this.mcast_port;
    }

    public void setMulticastPort(int mcast_port) {
        this.mcast_port = mcast_port;
    }

    public void setMcastPort(int mcast_port) {
        this.mcast_port = mcast_port;
    }

    public void setMulticastTTL(int ttl) {
        this.ip_ttl = ttl;
        this.setTimeToLive(ttl, this.sock);
    }

    public int getMulticastTTL() {
        return this.ip_ttl;
    }

    @Override
    public void setMaxBundleSize(int size) {
        super.setMaxBundleSize(size);
        if (size > 65536) {
            throw new IllegalArgumentException("max_bundle_size (" + size + ") cannot exceed the max datagram packet size of " + 65536);
        }
    }

    @ManagedAttribute(description="Number of messages dropped when sending because of insufficient buffer space")
    public int getDroppedMessage() {
        return this.suppress_log_out_of_buffer_space != null ? this.suppress_log_out_of_buffer_space.getCache().size() : 0;
    }

    @ManagedOperation(description="Clears the cache for dropped messages")
    public void clearDroppedMessagesCache() {
        if (this.suppress_log_out_of_buffer_space != null) {
            this.suppress_log_out_of_buffer_space.getCache().clear();
        }
    }

    @Override
    public String getInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("group_addr=").append(this.mcast_group_addr.getHostName()).append(':').append(this.mcast_port).append("\n");
        return sb.toString();
    }

    @Override
    public void sendMulticast(AsciiString cluster_name, byte[] data, int offset, int length) throws Exception {
        if (this.ip_mcast && this.mcast_addr != null) {
            this._send(this.mcast_addr.getIpAddress(), this.mcast_addr.getPort(), true, data, offset, length);
        } else if (!this.isSingleton()) {
            this.sendToMembers(this.members, data, offset, length);
        } else {
            TP.ProtocolAdapter prot_ad;
            Set<Address> mbrs = this.members;
            if (cluster_name != null && this.up_prots != null && (prot_ad = (TP.ProtocolAdapter)this.up_prots.get(cluster_name)) != null) {
                mbrs = prot_ad.getMembers();
            }
            this.sendToMembers((Collection<Address>)mbrs, data, offset, length);
        }
    }

    @Override
    public void sendUnicast(PhysicalAddress dest, byte[] data, int offset, int length) throws Exception {
        this._send(((IpAddress)dest).getIpAddress(), ((IpAddress)dest).getPort(), false, data, offset, length);
    }

    protected void _send(InetAddress dest, int port, boolean mcast2, byte[] data, int offset, int length) throws Exception {
        DatagramPacket packet = new DatagramPacket(data, offset, length, dest, port);
        if (this.sock != null) {
            try {
                this.sock.send(packet);
            }
            catch (IOException ex) {
                if (this.suppress_log_out_of_buffer_space != null) {
                    this.suppress_log_out_of_buffer_space.log(SuppressLog.Level.warn, dest, this.suppress_time_out_of_buffer_space, this.local_addr, dest == null ? "cluster" : dest, ex);
                }
                throw ex;
            }
        }
    }

    @Override
    protected Object handleDownEvent(Event evt) {
        Object retval = super.handleDownEvent(evt);
        switch (evt.getType()) {
            case 6: {
                if (this.suppress_log_out_of_buffer_space == null) break;
                this.suppress_log_out_of_buffer_space.removeExpired(this.suppress_time_out_of_buffer_space);
            }
        }
        return retval;
    }

    @Override
    public void init() throws Exception {
        super.init();
        if (is_mac && this.suppress_time_out_of_buffer_space > 0L) {
            this.suppress_log_out_of_buffer_space = new SuppressLog(this.log, "FailureSendingToPhysAddr", "SuppressMsg");
        }
    }

    @Override
    public void start() throws Exception {
        try {
            this.createSockets();
            super.start();
        }
        catch (Exception ex) {
            this.destroySockets();
            throw ex;
        }
        this.ucast_receiver = new PacketReceiver(this.sock, "unicast receiver", new Runnable(){

            @Override
            public void run() {
                UDP.this.closeUnicastSocket();
            }
        });
        if (this.ip_mcast) {
            this.mcast_receiver = new PacketReceiver(this.mcast_sock, "multicast receiver", new Runnable(){

                @Override
                public void run() {
                    UDP.this.closeMulticastSocket();
                }
            });
        }
    }

    @Override
    public void stop() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("closing sockets and stopping threads");
        }
        this.stopThreads();
        super.stop();
    }

    @Override
    public void destroy() {
        super.destroy();
        this.destroySockets();
    }

    @Override
    protected void handleConnect() throws Exception {
        if (this.isSingleton()) {
            if (this.connect_count == 0) {
                this.startThreads();
            }
            super.handleConnect();
        } else {
            this.startThreads();
        }
    }

    @Override
    protected void handleDisconnect() {
        if (this.isSingleton()) {
            super.handleDisconnect();
            if (this.connect_count == 0) {
                this.stopThreads();
            }
        } else {
            this.stopThreads();
        }
    }

    protected static Method findMethod(Class<?> clazz, String method_name, Class<?> ... parameters) {
        try {
            Method method = clazz.getDeclaredMethod(method_name, parameters);
            method.setAccessible(true);
            return method;
        }
        catch (Throwable t) {
            return null;
        }
    }

    protected void createSockets() throws Exception {
        if (this.bind_addr == null) {
            throw new IllegalArgumentException("bind_addr cannot be null");
        }
        Util.checkIfValidAddress(this.bind_addr, this.getName());
        if (this.log.isDebugEnabled()) {
            this.log.debug("sockets will use interface " + this.bind_addr.getHostAddress());
        }
        this.sock = this.bind_port > 0 ? this.createMulticastSocketWithBindPort() : this.createMulticastSocket("jgroups.udp.sock", 0);
        this.setTimeToLive(this.ip_ttl, this.sock);
        if (this.tos > 0) {
            try {
                this.sock.setTrafficClass(this.tos);
            }
            catch (SocketException e) {
                this.log.warn(Util.getMessage("TrafficClass"), this.tos, e);
            }
        }
        if (this.ip_mcast) {
            this.mcast_sock = can_bind_to_mcast_addr ? Util.createMulticastSocket(this.getSocketFactory(), "jgroups.udp.mcast_sock", this.mcast_group_addr, this.mcast_port, this.log) : this.getSocketFactory().createMulticastSocket("jgroups.udp.mcast_sock", this.mcast_port);
            if (this.disable_loopback) {
                this.mcast_sock.setLoopbackMode(this.disable_loopback);
            }
            this.mcast_addr = new IpAddress(this.mcast_group_addr, this.mcast_port);
            if (this.enable_diagnostics && this.diagnostics_addr.equals(this.mcast_group_addr) && this.diagnostics_port == this.mcast_port) {
                throw new IllegalArgumentException("diagnostics_addr:diagnostics_port and mcast_addr:mcast_port have to be different");
            }
            if (this.tos > 0) {
                try {
                    this.mcast_sock.setTrafficClass(this.tos);
                }
                catch (SocketException e) {
                    this.log.warn(Util.getMessage("TrafficClass"), this.tos, e);
                }
            }
            if (this.receive_on_all_interfaces || this.receive_interfaces != null && !this.receive_interfaces.isEmpty()) {
                List interfaces = this.receive_interfaces != null ? this.receive_interfaces : Util.getAllAvailableInterfaces();
                this.bindToInterfaces(interfaces, this.mcast_sock, this.mcast_addr.getIpAddress());
            } else {
                if (this.bind_addr != null) {
                    this.setInterface(this.bind_addr, this.mcast_sock);
                }
                this.mcast_sock.joinGroup(this.mcast_group_addr);
            }
        }
        this.setBufferSizes();
        this.log.debug("socket information:\n%s", this.dumpSocketInfo());
    }

    protected void destroySockets() {
        this.closeMulticastSocket();
        this.closeUnicastSocket();
    }

    protected IpAddress createLocalAddress() {
        if (this.sock == null || this.sock.isClosed()) {
            return null;
        }
        if (this.external_addr != null) {
            if (this.external_port > 0) {
                return new IpAddress(this.external_addr, this.external_port);
            }
            return new IpAddress(this.external_addr, this.sock.getLocalPort());
        }
        return new IpAddress(this.sock.getLocalAddress(), this.sock.getLocalPort());
    }

    protected void setTimeToLive(int ttl, MulticastSocket s) {
        try {
            if (s != null) {
                s.setTimeToLive(ttl);
            }
        }
        catch (Throwable ex) {
            this.log.error("failed setting ip_ttl to %d: %s", ttl, ex);
        }
    }

    protected void setInterface(InetAddress intf, MulticastSocket s) {
        try {
            if (s != null && intf != null) {
                s.setInterface(intf);
            }
        }
        catch (Throwable ex) {
            this.log.error("failed setting interface to %s: %s", intf, ex);
        }
    }

    @Override
    protected PhysicalAddress getPhysicalAddress() {
        return this.createLocalAddress();
    }

    protected void bindToInterfaces(List<NetworkInterface> interfaces, MulticastSocket s, InetAddress mcastAddr) {
        InetSocketAddress tmp_mcast_addr = new InetSocketAddress(mcastAddr, this.mcast_port);
        for (NetworkInterface intf : interfaces) {
            try {
                s.joinGroup(tmp_mcast_addr, intf);
                this.log.trace("joined %s on %s", tmp_mcast_addr, intf.getName());
            }
            catch (IOException e) {
                if (!this.log.isWarnEnabled()) continue;
                this.log.warn(Util.getMessage("InterfaceJoinFailed"), tmp_mcast_addr, intf.getName());
            }
        }
    }

    protected MulticastSocket createMulticastSocketWithBindPort() throws Exception {
        int rcv_port;
        MulticastSocket tmp = null;
        int max_port = this.bind_port + this.port_range;
        for (rcv_port = this.bind_port; rcv_port <= max_port; ++rcv_port) {
            try {
                return this.createMulticastSocket("jgroups.udp.sock", rcv_port);
            }
            catch (SecurityException | SocketException bind_ex) {
                continue;
            }
        }
        if (rcv_port >= max_port + 1) {
            throw new Exception("failed to open a port in range " + this.bind_port + '-' + max_port);
        }
        return tmp;
    }

    protected MulticastSocket createMulticastSocket(String service_name, int port) throws Exception {
        MulticastSocket retval = this.getSocketFactory().createMulticastSocket(service_name, null);
        if (this.bind_addr != null) {
            this.setInterface(this.bind_addr, retval);
        }
        retval.setReuseAddress(false);
        retval.bind(new InetSocketAddress(this.bind_addr, port));
        return retval;
    }

    protected String dumpSocketInfo() throws Exception {
        StringBuilder sb = new StringBuilder(128);
        Formatter formatter = new Formatter(sb);
        formatter.format("mcast_addr=%s, bind_addr=%s, ttl=%d", this.mcast_addr, this.bind_addr, this.ip_ttl);
        if (this.sock != null) {
            formatter.format("\nsock: bound to %s:%d, receive buffer size=%d, send buffer size=%d", this.sock.getLocalAddress().getHostAddress(), this.sock.getLocalPort(), this.sock.getReceiveBufferSize(), this.sock.getSendBufferSize());
        }
        if (this.mcast_sock != null) {
            formatter.format("\nmcast_sock: bound to %s:%d, send buffer size=%d, receive buffer size=%d", this.mcast_sock.getInterface().getHostAddress(), this.mcast_sock.getLocalPort(), this.mcast_sock.getSendBufferSize(), this.mcast_sock.getReceiveBufferSize());
        }
        return sb.toString();
    }

    void setBufferSizes() {
        if (this.sock != null) {
            this.setBufferSize(this.sock, this.ucast_send_buf_size, this.ucast_recv_buf_size);
        }
        if (this.mcast_sock != null) {
            this.setBufferSize(this.mcast_sock, this.mcast_send_buf_size, this.mcast_recv_buf_size);
        }
    }

    protected void setBufferSize(DatagramSocket sock, int send_buf_size, int recv_buf_size) {
        int actual_size;
        try {
            sock.setSendBufferSize(send_buf_size);
            actual_size = sock.getSendBufferSize();
            if (actual_size < send_buf_size && this.log.isWarnEnabled()) {
                this.log.warn(Util.getMessage("IncorrectBufferSize"), "send", sock.getClass().getSimpleName(), Util.printBytes(send_buf_size), Util.printBytes(actual_size), "send", "net.core.wmem_max");
            }
        }
        catch (Throwable ex) {
            this.log.warn(Util.getMessage("BufferSizeFailed"), "send", send_buf_size, sock, ex);
        }
        try {
            sock.setReceiveBufferSize(recv_buf_size);
            actual_size = sock.getReceiveBufferSize();
            if (actual_size < recv_buf_size && this.log.isWarnEnabled()) {
                this.log.warn(Util.getMessage("IncorrectBufferSize"), "receive", sock.getClass().getSimpleName(), Util.printBytes(recv_buf_size), Util.printBytes(actual_size), "receive", "net.core.rmem_max");
            }
        }
        catch (Throwable ex) {
            this.log.warn(Util.getMessage("BufferSizeFailed"), "receive", recv_buf_size, sock, ex);
        }
    }

    void closeMulticastSocket() {
        if (this.mcast_sock != null) {
            try {
                if (this.mcast_addr != null) {
                    this.mcast_sock.leaveGroup(this.mcast_addr.getIpAddress());
                }
                this.getSocketFactory().close(this.mcast_sock);
                this.mcast_sock = null;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("multicast socket closed");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.mcast_addr = null;
        }
    }

    protected void closeUnicastSocket() {
        this.getSocketFactory().close(this.sock);
    }

    void startThreads() throws Exception {
        this.ucast_receiver.start();
        if (this.mcast_receiver != null) {
            this.mcast_receiver.start();
        }
    }

    void stopThreads() {
        if (this.mcast_receiver != null) {
            this.mcast_receiver.stop();
        }
        if (this.ucast_receiver != null) {
            this.ucast_receiver.stop();
        }
    }

    protected void handleConfigEvent(Map<String, Object> map) {
        boolean set_buffers = false;
        if (map == null) {
            return;
        }
        if (map.containsKey("send_buf_size")) {
            this.ucast_send_buf_size = this.mcast_send_buf_size = ((Integer)map.get("send_buf_size")).intValue();
            set_buffers = true;
        }
        if (map.containsKey("recv_buf_size")) {
            this.ucast_recv_buf_size = this.mcast_recv_buf_size = ((Integer)map.get("recv_buf_size")).intValue();
            set_buffers = true;
        }
        if (set_buffers) {
            this.setBufferSizes();
        }
    }

    public class PacketReceiver
    implements Runnable {
        private Thread thread = null;
        private final DatagramSocket receiver_socket;
        private final String name;
        private final Runnable close_strategy;

        public PacketReceiver(DatagramSocket socket, String name, Runnable close_strategy) {
            this.receiver_socket = socket;
            this.name = name;
            this.close_strategy = close_strategy;
        }

        public synchronized void start() {
            if (this.thread == null || !this.thread.isAlive()) {
                this.thread = UDP.this.getThreadFactory().newThread(this, this.name);
                this.thread.start();
            }
        }

        public synchronized void stop() {
            Thread tmp = this.thread;
            this.thread = null;
            try {
                this.close_strategy.run();
            }
            catch (Exception exception) {
            }
            finally {
                Util.close((Closeable)this.receiver_socket);
            }
            if (tmp != null && tmp.isAlive()) {
                tmp.interrupt();
                try {
                    tmp.join(300L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        @Override
        public void run() {
            byte[] receive_buf = new byte[66000];
            DatagramPacket packet = new DatagramPacket(receive_buf, receive_buf.length);
            while (this.thread != null && Thread.currentThread().equals(this.thread)) {
                try {
                    if (is_android) {
                        packet.setLength(receive_buf.length);
                    }
                    this.receiver_socket.receive(packet);
                    int len = packet.getLength();
                    if (len > receive_buf.length && UDP.this.log.isErrorEnabled()) {
                        UDP.this.log.error(Util.getMessage("SizeOfTheReceivedPacket"), len, receive_buf.length, receive_buf.length);
                    }
                    UDP.this.receive(new IpAddress(packet.getAddress(), packet.getPort()), receive_buf, packet.getOffset(), len);
                }
                catch (SocketException sock_ex) {
                    if (this.receiver_socket.isClosed()) {
                        if (!UDP.this.log.isDebugEnabled()) break;
                        UDP.this.log.debug("receiver socket is closed, exception=" + sock_ex);
                        break;
                    }
                    UDP.this.log.error(Util.getMessage("FailedReceivingPacket"), sock_ex);
                }
                catch (Throwable ex) {
                    if (!UDP.this.log.isErrorEnabled()) continue;
                    UDP.this.log.error(Util.getMessage("FailedReceivingPacket"), ex);
                }
            }
            if (UDP.this.log.isDebugEnabled()) {
                UDP.this.log.debug(this.name + " thread terminated");
            }
        }

        public String toString() {
            return this.receiver_socket != null ? this.receiver_socket.getLocalSocketAddress().toString() : "null";
        }
    }
}

