/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.pdx.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.InternalGemFireException;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.CacheWriterException;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.EntryEvent;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionExistsException;
import org.apache.geode.cache.Scope;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.cache.TransactionException;
import org.apache.geode.cache.asyncqueue.internal.AsyncEventQueueImpl;
import org.apache.geode.cache.client.Pool;
import org.apache.geode.cache.client.PoolManager;
import org.apache.geode.cache.client.internal.PoolImpl;
import org.apache.geode.cache.util.CacheListenerAdapter;
import org.apache.geode.cache.util.CacheWriterAdapter;
import org.apache.geode.cache.wan.GatewaySender;
import org.apache.geode.distributed.DistributedLockService;
import org.apache.geode.distributed.LockServiceDestroyedException;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.locks.DLockService;
import org.apache.geode.internal.CopyOnWriteHashSet;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalRegionFactory;
import org.apache.geode.internal.cache.TXManagerImpl;
import org.apache.geode.internal.cache.TXStateProxy;
import org.apache.geode.internal.util.concurrent.CopyOnWriteHashMap;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.pdx.PdxInitializationException;
import org.apache.geode.pdx.PdxRegistryMismatchException;
import org.apache.geode.pdx.internal.CheckTypeRegistryState;
import org.apache.geode.pdx.internal.EnumId;
import org.apache.geode.pdx.internal.EnumInfo;
import org.apache.geode.pdx.internal.PdxType;
import org.apache.geode.pdx.internal.PeerTypeRegistrationReverseMap;
import org.apache.geode.pdx.internal.TypeRegistration;
import org.apache.geode.pdx.internal.TypeRegistrationStatistics;
import org.apache.geode.pdx.internal.TypeRegistry;
import org.apache.logging.log4j.Logger;

public class PeerTypeRegistration
implements TypeRegistration {
    private static final Logger logger = LogService.getLogger();
    private static final int MAX_TRANSACTION_FAILURES = 10;
    public static final String LOCK_SERVICE_NAME = "__PDX";
    private static final String LOCK_NAME = "PDX_LOCK";
    public static final String REGION_NAME = "PdxTypes";
    public static final String REGION_FULL_PATH = "/PdxTypes";
    @VisibleForTesting
    public static final int PLACE_HOLDER_FOR_TYPE_ID = 0xFFFFFF;
    private static final int PLACE_HOLDER_FOR_DS_ID = -16777216;
    private static final int MAX_TYPE_ID = 0xFFFFFF;
    private final TypeRegistrationStatistics statistics;
    private final int typeIdPrefix;
    private final Object dlsLock = new Object();
    private final InternalCache cache;
    private volatile DistributedLockService dls;
    private Region<Object, Object> idToType;
    private PeerTypeRegistrationReverseMap reverseMap = new PeerTypeRegistrationReverseMap();
    private final Map<String, CopyOnWriteHashSet<PdxType>> classToType = new CopyOnWriteHashMap<String, CopyOnWriteHashSet<PdxType>>();
    private volatile boolean typeRegistryInUse = false;

    public PeerTypeRegistration(InternalCache cache) {
        this.cache = cache;
        InternalDistributedSystem internalDistributedSystem = cache.getInternalDistributedSystem();
        this.typeIdPrefix = PeerTypeRegistration.getDistributedSystemId(internalDistributedSystem) << 24;
        this.statistics = new TypeRegistrationStatistics(internalDistributedSystem.getStatisticsManager(), this);
    }

    private static int getDistributedSystemId(InternalDistributedSystem internalDistributedSystem) {
        int distributedSystemId = internalDistributedSystem.getDistributionManager().getDistributedSystemId();
        if (distributedSystemId == -1) {
            return 0;
        }
        return distributedSystemId;
    }

    private Region<Object, Object> getIdToType() {
        if (this.idToType != null) {
            return this.idToType;
        }
        if (this.cache.getPdxPersistent() && this.cache.getCacheConfig().pdxDiskStoreUserSet) {
            throw new PdxInitializationException("PDX registry could not be initialized because the disk store " + this.cache.getPdxDiskStore() + " was not created.");
        }
        throw new PdxInitializationException("PDX registry was not initialized.");
    }

    @Override
    public void initialize() {
        TypeRegistry typeRegistry = this.cache.getPdxRegistry();
        if (typeRegistry != null) {
            typeRegistry.flushCache();
            logger.debug("Flushing TypeRegistry");
        }
        InternalRegionFactory<Object, Object> factory = this.cache.createInternalRegionFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        if (this.cache.getPdxPersistent()) {
            if (this.cache.getCacheConfig().pdxDiskStoreUserSet) {
                factory.setDiskStoreName(this.cache.getPdxDiskStore());
            } else {
                factory.setDiskStoreName(this.cache.getOrCreateDefaultDiskStore().getName());
            }
            factory.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
        } else {
            factory.setDataPolicy(DataPolicy.REPLICATE);
        }
        factory.addCacheListener(new CacheListenerAdapter<Object, Object>(){

            @Override
            public void afterCreate(EntryEvent<Object, Object> event) {
                PeerTypeRegistration.this.verifyConfiguration();
                Object value = event.getNewValue();
                Object key = event.getKey();
                if (value != null) {
                    PeerTypeRegistration.this.updateLocalAndReverseMaps(key, value);
                }
            }
        });
        factory.setCacheWriter(new CacheWriterAdapter<Object, Object>(){

            @Override
            public void beforeCreate(EntryEvent<Object, Object> event) throws CacheWriterException {
                Object newValue = event.getNewValue();
                if (newValue instanceof PdxType) {
                    logger.info("Adding new type: {}", (Object)((PdxType)event.getNewValue()).toFormattedString());
                } else {
                    logger.info("Adding new type: {} {}", event.getKey(), (Object)((EnumInfo)newValue).toFormattedString());
                }
            }

            @Override
            public void beforeUpdate(EntryEvent<Object, Object> event) throws CacheWriterException {
                if (!event.getRegion().get(event.getKey()).equals(event.getNewValue())) {
                    PdxRegistryMismatchException ex = new PdxRegistryMismatchException("Trying to add a PDXType with the same id as an existing PDX type. id=" + event.getKey() + ", existing pdx type " + event.getOldValue() + ", new type " + event.getNewValue());
                    throw new CacheWriterException(ex);
                }
            }
        });
        factory.setIsUsedForMetaRegion(true);
        factory.setMetaRegionWithTransactions(true);
        try {
            this.idToType = factory.create(REGION_NAME);
        }
        catch (RegionExistsException | TimeoutException ex) {
            throw new PdxInitializationException("Could not create pdx registry", ex);
        }
        this.statistics.initialize();
        if (!this.getIdToType().isEmpty()) {
            this.verifyConfiguration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DistributedLockService getLockService() {
        if (this.dls != null) {
            return this.dls;
        }
        Object object = this.dlsLock;
        synchronized (object) {
            block7: {
                if (this.dls == null) {
                    try {
                        this.dls = DLockService.create(LOCK_SERVICE_NAME, this.cache.getInternalDistributedSystem(), true, true, true);
                    }
                    catch (IllegalArgumentException e) {
                        this.dls = DistributedLockService.getServiceNamed(LOCK_SERVICE_NAME);
                        if (this.dls != null) break block7;
                        throw e;
                    }
                }
            }
            return this.dls;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int allocateTypeId(PdxType newType) {
        TXStateProxy currentState = this.suspendTX();
        Region<Object, Object> r = this.getIdToType();
        int id = newType.hashCode() & 0xFFFFFF;
        int newTypeId = id | this.typeIdPrefix;
        try {
            int maxTry = 0xFFFFFF;
            while (r.get(newTypeId) != null) {
                if (--maxTry == 0) {
                    throw new InternalGemFireError("Used up all of the PDX type ids for this distributed system. The maximum number of PDX types is 16777215");
                }
                if (++id > 0xFFFFFF) {
                    id = 1;
                }
                newTypeId = id | this.typeIdPrefix;
            }
            int n = newTypeId;
            return n;
        }
        finally {
            this.resumeTX(currentState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EnumId allocateEnumId(EnumInfo ei) {
        TXStateProxy currentState = this.suspendTX();
        Region<Object, Object> r = this.getIdToType();
        int id = ei.hashCode() & 0xFFFFFF;
        int newEnumId = id | this.typeIdPrefix;
        try {
            int maxTry = 0xFFFFFF;
            while (r.get(new EnumId(newEnumId)) != null) {
                if (--maxTry == 0) {
                    throw new InternalGemFireError("Used up all of the PDX type ids for this distributed system. The maximum number of PDX types is 16777215");
                }
                if (++id > 0xFFFFFF) {
                    id = 1;
                }
                newEnumId = id | this.typeIdPrefix;
            }
            EnumId enumId = new EnumId(newEnumId);
            return enumId;
        }
        finally {
            this.resumeTX(currentState);
        }
    }

    private void unlock() {
        try {
            DistributedLockService dls = this.getLockService();
            dls.unlock(LOCK_NAME);
        }
        catch (LockServiceDestroyedException e) {
            this.cache.getCancelCriterion().checkCancelInProgress(e);
            throw e;
        }
    }

    private void lock() {
        DistributedLockService dls = this.getLockService();
        try {
            if (!dls.lock(LOCK_NAME, -1L, -1L)) {
                throw new InternalGemFireException("Could not obtain pdx lock");
            }
        }
        catch (LockServiceDestroyedException e) {
            this.cache.getCancelCriterion().checkCancelInProgress(e);
            throw e;
        }
    }

    private boolean useUDPMessagingIfNecessary() {
        boolean result = false;
        InternalDistributedSystem sys = this.cache.getInternalDistributedSystem();
        if (sys != null && !sys.threadOwnsResources()) {
            sys.getDistributionManager().forceUDPMessagingForCurrentThread();
            result = true;
        }
        return result;
    }

    private void releaseUDPMessaging(boolean release) {
        InternalDistributedSystem sys;
        if (release && (sys = this.cache.getInternalDistributedSystem()) != null) {
            sys.getDistributionManager().releaseUDPMessagingForCurrentThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int defineType(PdxType newType) {
        this.statistics.typeDefined();
        this.verifyConfiguration();
        Integer existingId = this.reverseMap.getIdFromReverseMap(newType);
        if (existingId != null) {
            return existingId;
        }
        this.lock();
        try {
            if (this.shouldReload()) {
                this.buildReverseMapsFromRegion();
            }
            this.reverseMap.flushPendingReverseMap();
            existingId = this.reverseMap.getIdFromReverseMap(newType);
            if (existingId != null) {
                int n = existingId;
                return n;
            }
            int id = this.allocateTypeId(newType);
            newType.setTypeId(id);
            this.updateIdToTypeRegion(newType);
            int n = newType.getTypeId();
            return n;
        }
        finally {
            this.reverseMap.flushPendingReverseMap();
            this.unlock();
        }
    }

    private void updateIdToTypeRegion(PdxType newType) {
        this.updateRegion(newType.getTypeId(), newType);
        this.statistics.typeCreated();
    }

    private void updateIdToEnumRegion(EnumId id, EnumInfo ei) {
        this.updateRegion(id, ei);
        this.statistics.enumCreated();
    }

    private void updateRegion(Object k, Object v) {
        Region<Object, Object> r = this.getIdToType();
        InternalCache cache = (InternalCache)r.getRegionService();
        this.checkDistributedTypeRegistryState();
        TXManagerImpl txManager = (TXManagerImpl)cache.getCacheTransactionManager();
        TXStateProxy currentState = this.suspendTX();
        boolean state = this.useUDPMessagingIfNecessary();
        try {
            int failureCount = 0;
            while (true) {
                txManager.begin();
                try {
                    r.put(k, v);
                    txManager.commit();
                    return;
                }
                catch (TransactionException e) {
                    if (!txManager.exists()) continue;
                    txManager.rollback();
                    if (++failureCount <= 10) continue;
                    throw e;
                }
                break;
            }
        }
        finally {
            this.releaseUDPMessaging(state);
            this.resumeTX(currentState);
        }
    }

    private void checkDistributedTypeRegistryState() {
        CheckTypeRegistryState.send(this.cache.getDistributionManager());
    }

    @Override
    public PdxType getType(int typeId) {
        return (PdxType)this.getById(typeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T getById(Object typeId) {
        this.verifyConfiguration();
        TXStateProxy currentState = this.suspendTX();
        try {
            Object pdxType = this.getIdToType().get(typeId);
            if (pdxType == null) {
                this.lock();
                try {
                    pdxType = this.getIdToType().get(typeId);
                }
                finally {
                    this.unlock();
                }
            }
            Object object = pdxType;
            return (T)object;
        }
        finally {
            this.resumeTX(currentState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRemoteType(int typeId, PdxType type) {
        block6: {
            this.verifyConfiguration();
            TXStateProxy currentState = this.suspendTX();
            Region<Object, Object> r = this.getIdToType();
            try {
                if (r.containsKey(typeId)) break block6;
                this.lock();
                try {
                    r.putIfAbsent(typeId, type);
                }
                finally {
                    this.unlock();
                }
            }
            finally {
                this.resumeTX(currentState);
            }
        }
    }

    @Override
    public void gatewaySenderStarted(GatewaySender gatewaySender) {
        if (!this.typeRegistryInUse || this.idToType == null) {
            return;
        }
        this.checkAllowed(true, this.cache.hasPersistentRegion());
    }

    @Override
    public void creatingPersistentRegion() {
        if (!this.typeRegistryInUse) {
            return;
        }
        this.checkAllowed(this.hasGatewaySender(), true);
    }

    private boolean hasGatewaySender() {
        Set<GatewaySender> sendersAndAsyncQueues = this.cache.getGatewaySenders();
        sendersAndAsyncQueues.removeIf(sender -> AsyncEventQueueImpl.isAsyncEventQueue(sender.getId()));
        return !sendersAndAsyncQueues.isEmpty();
    }

    @Override
    public void creatingPool() {
        if (this.typeRegistryInUse) {
            throw new PdxInitializationException("The PDX metadata has already been created as a peer metadata region. Please create your pools first");
        }
    }

    void verifyConfiguration() {
        if (!this.typeRegistryInUse) {
            this.checkAllowed(this.hasGatewaySender(), this.cache.hasPersistentRegion());
            for (Pool pool : PoolManager.getAll().values()) {
                if (((PoolImpl)pool).isUsedByGateway()) continue;
                throw new PdxInitializationException("The PDX metadata has already been created as a peer metadata region. Please use ClientCacheFactory to create clients.");
            }
            this.typeRegistryInUse = true;
        }
    }

    private void checkAllowed(boolean hasGatewaySender, boolean hasPersistentRegion) {
        if (hasPersistentRegion && !this.cache.getPdxPersistent()) {
            throw new PdxInitializationException("The PDX metadata must be persistent in a member that has persistent data. See CacheFactory.setPdxPersistent.");
        }
        int distributedSystemId = this.cache.getInternalDistributedSystem().getDistributionManager().getDistributedSystemId();
        if (hasGatewaySender && distributedSystemId == -1) {
            throw new PdxInitializationException("When using PDX with a WAN gateway sender, you must set the distributed-system-id gemfire property for your distributed system. See the javadocs for DistributedSystem.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void buildReverseMapsFromRegion() {
        int totalPdxTypeIdInDS = 0;
        int totalEnumIdInDS = 0;
        TXStateProxy currentState = this.suspendTX();
        try {
            this.reverseMap.clear();
            for (Map.Entry<Object, Object> entry : this.getIdToType().entrySet()) {
                int tmpDsId;
                Object id;
                Object k = entry.getKey();
                Object v = entry.getValue();
                if (k instanceof EnumId) {
                    id = (EnumId)k;
                    tmpDsId = 0xFF000000 & ((EnumId)id).intValue();
                    if (tmpDsId == this.typeIdPrefix && ++totalEnumIdInDS >= 0xFFFFFF) {
                        throw new InternalGemFireError("Used up all of the PDX enum ids for this distributed system. The maximum number of PDX types is 16777215");
                    }
                } else {
                    id = (Integer)k;
                    tmpDsId = 0xFF000000 & (Integer)id;
                    if (tmpDsId == this.typeIdPrefix && ++totalPdxTypeIdInDS >= 0xFFFFFF) {
                        throw new InternalGemFireError("Used up all of the PDX type ids for this distributed system. The maximum number of PDX types is 16777215");
                    }
                }
                this.reverseMap.save(k, v);
            }
        }
        finally {
            this.resumeTX(currentState);
        }
    }

    private TXStateProxy suspendTX() {
        InternalCache cache = (InternalCache)this.getIdToType().getRegionService();
        TXManagerImpl txManager = (TXManagerImpl)cache.getCacheTransactionManager();
        return txManager.internalSuspend();
    }

    private void resumeTX(TXStateProxy state) {
        if (state != null) {
            TXManagerImpl txManager = state.getTxMgr();
            txManager.internalResume(state);
        }
    }

    @Override
    public int getEnumId(Enum<?> v) {
        return this.defineEnum(new EnumInfo(v));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRemoteEnum(int id, EnumInfo enumInfo) {
        block6: {
            this.verifyConfiguration();
            TXStateProxy currentState = this.suspendTX();
            EnumId enumId = new EnumId(id);
            Region<Object, Object> r = this.getIdToType();
            try {
                if (r.containsKey(enumId)) break block6;
                this.lock();
                try {
                    r.put(enumId, enumInfo);
                }
                finally {
                    this.unlock();
                }
            }
            finally {
                this.resumeTX(currentState);
            }
        }
    }

    boolean shouldReload() {
        boolean shouldReload = false;
        TXStateProxy currentState = this.suspendTX();
        try {
            shouldReload = this.reverseMap.shouldReloadFromRegion(this.getIdToType());
        }
        finally {
            this.resumeTX(currentState);
        }
        return shouldReload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int defineEnum(EnumInfo newInfo) {
        this.statistics.enumDefined();
        this.verifyConfiguration();
        EnumId existingId = this.reverseMap.getIdFromReverseMap(newInfo);
        if (existingId != null) {
            return existingId.intValue();
        }
        this.lock();
        try {
            if (this.shouldReload()) {
                this.buildReverseMapsFromRegion();
            }
            this.reverseMap.flushPendingReverseMap();
            existingId = this.reverseMap.getIdFromReverseMap(newInfo);
            if (existingId != null) {
                int n = existingId.intValue();
                return n;
            }
            EnumId id = this.allocateEnumId(newInfo);
            this.updateIdToEnumRegion(id, newInfo);
            int n = id.intValue();
            return n;
        }
        finally {
            this.reverseMap.flushPendingReverseMap();
            this.unlock();
        }
    }

    @Override
    public EnumInfo getEnumById(int id) {
        EnumId enumId = new EnumId(id);
        return (EnumInfo)this.getById(enumId);
    }

    @Override
    public Map<Integer, PdxType> types() {
        HashMap<Integer, PdxType> types = new HashMap<Integer, PdxType>();
        for (Map.Entry<Object, Object> type : this.getIdToType().entrySet()) {
            Object id = type.getKey();
            if (!(type.getValue() instanceof PdxType)) continue;
            types.put((Integer)id, (PdxType)type.getValue());
        }
        return types;
    }

    @Override
    public Map<Integer, EnumInfo> enums() {
        HashMap<Integer, EnumInfo> enums = new HashMap<Integer, EnumInfo>();
        for (Map.Entry<Object, Object> type : this.getIdToType().entrySet()) {
            Object id = type.getKey();
            if (!(type.getValue() instanceof EnumInfo)) continue;
            enums.put(((EnumId)id).intValue(), (EnumInfo)type.getValue());
        }
        return enums;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLocalAndReverseMaps(Object key, Object value) {
        this.reverseMap.saveToPending(key, value);
        if (value instanceof PdxType) {
            PdxType type = (PdxType)value;
            Map<String, CopyOnWriteHashSet<PdxType>> map = this.classToType;
            synchronized (map) {
                if (type.getClassName().equals("__GEMFIRE_JSON")) {
                    return;
                }
                CopyOnWriteHashSet<PdxType> pdxTypeSet = this.classToType.get(type.getClassName());
                if (pdxTypeSet == null) {
                    pdxTypeSet = new CopyOnWriteHashSet();
                }
                pdxTypeSet.add(type);
                this.classToType.put(type.getClassName(), pdxTypeSet);
            }
        }
    }

    @Override
    public PdxType getPdxTypeForField(String fieldName, String className) {
        Set<PdxType> pdxTypes = this.getPdxTypesForClassName(className);
        for (PdxType pdxType : pdxTypes) {
            if (pdxType.getPdxField(fieldName) == null) continue;
            return pdxType;
        }
        return null;
    }

    @Override
    public Set<PdxType> getPdxTypesForClassName(String className) {
        CopyOnWriteHashSet<PdxType> pdxTypeSet = this.classToType.get(className);
        if (pdxTypeSet == null) {
            return Collections.emptySet();
        }
        return pdxTypeSet.getSnapshot();
    }

    @Override
    public boolean isClient() {
        return false;
    }

    @Override
    public void addImportedType(int typeId, PdxType importedType) {
        this.addRemoteType(typeId, importedType);
    }

    @Override
    public void addImportedEnum(int id, EnumInfo importedInfo) {
        this.addRemoteEnum(id, importedInfo);
    }

    @Deprecated
    public static int getPdxRegistrySize() {
        GemFireCacheImpl cache = GemFireCacheImpl.getExisting();
        TypeRegistry registry = cache.getPdxRegistry();
        if (registry == null) {
            return 0;
        }
        return registry.getLocalSize();
    }

    @Override
    public int getLocalSize() {
        if (this.cache.isClosed()) {
            return 0;
        }
        return this.getIdToType().size();
    }

    @VisibleForTesting
    public int getTypeToIdSize() {
        return this.reverseMap.typeToIdSize();
    }

    @VisibleForTesting
    public int getEnumToIdSize() {
        return this.reverseMap.enumToIdSize();
    }
}

