/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.configuration.realizers;

import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.geode.cache.DiskStore;
import org.apache.geode.cache.DiskStoreFactory;
import org.apache.geode.internal.cache.DiskStoreAttributes;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.management.api.RealizationResult;
import org.apache.geode.management.internal.configuration.realizers.ConfigurationRealizer;
import org.apache.geode.management.runtime.DiskStoreInfo;

public class DiskStoreRealizer
implements ConfigurationRealizer<org.apache.geode.management.configuration.DiskStore, DiskStoreInfo> {
    @Override
    public RealizationResult create(org.apache.geode.management.configuration.DiskStore config, InternalCache cache) throws Exception {
        DiskStoreAttributes diskStoreAttributes = new DiskStoreAttributes();
        if (config.isAllowForceCompaction() != null) {
            diskStoreAttributes.allowForceCompaction = config.isAllowForceCompaction();
        }
        if (config.isAutoCompact() != null) {
            diskStoreAttributes.autoCompact = config.isAutoCompact();
        }
        if (config.getCompactionThreshold() != null) {
            diskStoreAttributes.compactionThreshold = config.getCompactionThreshold();
        }
        if (config.getDiskUsageCriticalPercentage() != null) {
            diskStoreAttributes.setDiskUsageCriticalPercentage(config.getDiskUsageCriticalPercentage().floatValue());
        }
        if (config.getDiskUsageWarningPercentage() != null) {
            diskStoreAttributes.setDiskUsageWarningPercentage(config.getDiskUsageWarningPercentage().floatValue());
        }
        if (config.getMaxOplogSizeInBytes() != null) {
            diskStoreAttributes.maxOplogSizeInBytes = config.getMaxOplogSizeInBytes();
        }
        if (config.getQueueSize() != null) {
            diskStoreAttributes.queueSize = config.getQueueSize();
        }
        if (config.getTimeInterval() != null) {
            diskStoreAttributes.timeInterval = config.getTimeInterval();
        }
        if (config.getWriteBufferSize() != null) {
            diskStoreAttributes.writeBufferSize = config.getWriteBufferSize();
        }
        List<File> fileList = config.getDirectories().stream().map(diskDir -> new File(diskDir.getName())).collect(Collectors.toList());
        diskStoreAttributes.diskDirs = fileList.toArray(diskStoreAttributes.diskDirs);
        diskStoreAttributes.diskDirSizes = config.getDirectories().stream().mapToInt(diskDir -> {
            if (diskDir.getDirSize() != null) {
                return diskDir.getDirSize();
            }
            return Integer.MAX_VALUE;
        }).toArray();
        DiskStoreFactory diskStoreFactory = cache.createDiskStoreFactory(diskStoreAttributes);
        diskStoreFactory.create(config.getName());
        return new RealizationResult().setMessage("DiskStore " + config.getName() + " created successfully.");
    }

    @Override
    public boolean exists(org.apache.geode.management.configuration.DiskStore config, InternalCache cache) {
        return cache.listDiskStores().stream().anyMatch(diskStore -> diskStore.getName().equals(config.getName()));
    }

    @Override
    public DiskStoreInfo get(org.apache.geode.management.configuration.DiskStore config, InternalCache cache) {
        return new DiskStoreInfo();
    }

    @Override
    public RealizationResult update(org.apache.geode.management.configuration.DiskStore config, InternalCache cache) throws Exception {
        return null;
    }

    @Override
    public RealizationResult delete(org.apache.geode.management.configuration.DiskStore config, InternalCache cache) throws Exception {
        DiskStore diskStore = cache.findDiskStore(config.getName());
        if (diskStore != null) {
            diskStore.destroy();
            return new RealizationResult().setMessage("DiskStore " + config.getName() + " deleted successfully.");
        }
        return new RealizationResult().setMessage("DiskStore " + config.getName() + " not found.").setSuccess(false);
    }

    @Override
    public boolean isReadyOnly() {
        return false;
    }
}

