/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.process;

import java.util.function.Consumer;
import org.apache.commons.lang3.Validate;
import org.apache.geode.internal.process.StartupStatusListener;
import org.apache.geode.internal.process.StartupStatusListenerRegistry;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class StartupStatus {
    private static final Logger LOGGER = LogService.getLogger();
    private final Consumer<String> logger;

    public StartupStatus() {
        this(arg_0 -> ((Logger)LOGGER).info(arg_0));
    }

    private StartupStatus(Consumer<String> logger) {
        this.logger = logger;
    }

    public void startup(String message, Object ... params) {
        Validate.notNull((Object)message, (String)("Invalid message '" + message + "' specified"), (Object[])new Object[0]);
        Validate.notNull((Object)params, (String)"Invalid params specified", (Object[])new Object[0]);
        String formattedMessage = String.format(message, params);
        StartupStatusListener listener = StartupStatusListenerRegistry.getStartupListener();
        if (listener != null) {
            listener.setStatus(formattedMessage);
        }
        this.logger.accept(formattedMessage);
    }
}

