/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.net;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.geode.GemFireConfigException;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.internal.net.SSLConfig;
import org.apache.geode.internal.net.SSLConfigurationFactory;
import org.apache.geode.internal.net.SocketCreator;
import org.apache.geode.internal.security.SecurableCommunicationChannel;

public class SocketCreatorFactory {
    @MakeNotStatic
    private static SocketCreatorFactory instance = null;
    @MakeNotStatic
    private Map<SecurableCommunicationChannel, SocketCreator> socketCreators = new HashMap<SecurableCommunicationChannel, SocketCreator>();
    private DistributionConfig distributionConfig;

    private void initializeSocketCreators(DistributionConfig distributionConfig) {
        if (distributionConfig == null) {
            throw new GemFireConfigException("SocketCreatorFactory requires a valid distribution config.");
        }
        this.distributionConfig = distributionConfig;
    }

    private DistributionConfig getDistributionConfig() {
        if (this.distributionConfig == null) {
            throw new GemFireConfigException("SocketCreatorFactory requires a valid distribution config.");
        }
        return this.distributionConfig;
    }

    private static synchronized SocketCreatorFactory getInstance(boolean closing) {
        if (instance == null && !closing) {
            instance = new SocketCreatorFactory();
        }
        return instance;
    }

    private static synchronized SocketCreatorFactory getInstance() {
        return SocketCreatorFactory.getInstance(false);
    }

    public static SocketCreator getSocketCreatorForComponent(DistributionConfig distributionConfig, SecurableCommunicationChannel sslEnabledComponent) {
        SSLConfig sslConfigForComponent = SSLConfigurationFactory.getSSLConfigForComponent(distributionConfig, sslEnabledComponent);
        return SocketCreatorFactory.getInstance().getOrCreateSocketCreatorForSSLEnabledComponent(sslEnabledComponent, sslConfigForComponent);
    }

    public static SocketCreator getSocketCreatorForComponent(SecurableCommunicationChannel sslEnabledComponent) {
        return SocketCreatorFactory.getSocketCreatorForComponent(SocketCreatorFactory.getInstance().getDistributionConfig(), sslEnabledComponent);
    }

    private SocketCreator getSSLSocketCreator(SecurableCommunicationChannel sslComponent, SSLConfig sslConfig) {
        if (sslConfig.isEnabled()) {
            if (ArrayUtils.contains((Object[])this.getDistributionConfig().getSecurableCommunicationChannels(), (Object)((Object)SecurableCommunicationChannel.ALL))) {
                return this.createSSLSocketCreator(SecurableCommunicationChannel.ALL, sslConfig);
            }
            return this.createSSLSocketCreator(sslComponent, sslConfig);
        }
        return this.createSSLSocketCreator(sslComponent, sslConfig);
    }

    private SocketCreator getOrCreateSocketCreatorForSSLEnabledComponent(SecurableCommunicationChannel sslEnabledComponent, SSLConfig sslConfig) {
        SocketCreator socketCreator = this.getRegisteredSocketCreatorForComponent(sslEnabledComponent);
        if (socketCreator == null) {
            return this.getSSLSocketCreator(sslEnabledComponent, sslConfig);
        }
        return socketCreator;
    }

    private SocketCreator createSSLSocketCreator(SecurableCommunicationChannel sslEnableComponent, SSLConfig sslConfig) {
        SocketCreator socketCreator = null;
        if (sslConfig.isEnabled()) {
            socketCreator = new SocketCreator(sslConfig);
            this.registerSocketCreatorForComponent(sslEnableComponent, socketCreator);
        } else {
            socketCreator = this.getRegisteredSocketCreatorForComponent(sslEnableComponent);
            if (socketCreator == null) {
                socketCreator = new SocketCreator(sslConfig);
                this.registerSocketCreatorForComponent(sslEnableComponent, socketCreator);
            }
        }
        return socketCreator;
    }

    private synchronized void registerSocketCreatorForComponent(SecurableCommunicationChannel sslEnabledComponent, SocketCreator socketCreator) {
        this.socketCreators.put(sslEnabledComponent, socketCreator);
    }

    private synchronized SocketCreator getRegisteredSocketCreatorForComponent(SecurableCommunicationChannel sslEnabledComponent) {
        return this.socketCreators.get((Object)sslEnabledComponent);
    }

    @Deprecated
    public static SocketCreator createNonDefaultInstance(boolean useSSL, boolean needClientAuth, String protocols, String ciphers, Properties gfsecurityProps) {
        SSLConfig sslConfig = SSLConfigurationFactory.getSSLConfigForComponent(useSSL, needClientAuth, protocols, ciphers, gfsecurityProps, null);
        return new SocketCreator(sslConfig);
    }

    public static void close() {
        SocketCreatorFactory socketCreatorFactory = SocketCreatorFactory.getInstance(true);
        if (socketCreatorFactory != null) {
            socketCreatorFactory.clearSocketCreators();
            socketCreatorFactory.distributionConfig = null;
        }
    }

    private synchronized void clearSocketCreators() {
        this.socketCreators.clear();
    }

    public static SocketCreatorFactory setDistributionConfig(DistributionConfig config) {
        SocketCreatorFactory.getInstance().initializeSocketCreators(config);
        return SocketCreatorFactory.getInstance();
    }
}

