/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.net;

import java.io.Console;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.InetAddressValidator;
import org.apache.geode.GemFireConfigException;
import org.apache.geode.SystemFailure;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.cache.wan.GatewaySender;
import org.apache.geode.cache.wan.GatewayTransportFilter;
import org.apache.geode.distributed.ClientSocketFactory;
import org.apache.geode.distributed.internal.DistributionConfigImpl;
import org.apache.geode.distributed.internal.tcpserver.AdvancedSocketCreatorImpl;
import org.apache.geode.distributed.internal.tcpserver.HostAndPort;
import org.apache.geode.distributed.internal.tcpserver.TcpSocketCreatorImpl;
import org.apache.geode.internal.ClassPathLoader;
import org.apache.geode.internal.cache.wan.TransportFilterServerSocket;
import org.apache.geode.internal.cache.wan.TransportFilterSocketFactory;
import org.apache.geode.internal.inet.LocalHostUtil;
import org.apache.geode.internal.net.BufferPool;
import org.apache.geode.internal.net.NioSslEngine;
import org.apache.geode.internal.net.SCAdvancedSocketCreator;
import org.apache.geode.internal.net.SCClientSocketCreator;
import org.apache.geode.internal.net.SCClusterSocketCreator;
import org.apache.geode.internal.net.SSLConfig;
import org.apache.geode.internal.net.SSLUtil;
import org.apache.geode.internal.tcp.TCPConduit;
import org.apache.geode.internal.util.ArgumentRedactor;
import org.apache.geode.internal.util.PasswordUtil;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.net.SSLParameterExtension;
import org.apache.logging.log4j.Logger;

public class SocketCreator
extends TcpSocketCreatorImpl {
    private static final Logger logger = LogService.getLogger();
    public static final boolean FORCE_DNS_USE = Boolean.getBoolean("gemfire.forceDnsUse");
    @MakeNotStatic
    public static volatile boolean resolve_dns = true;
    @MakeNotStatic
    public static volatile boolean use_client_host_name = true;
    @MakeNotStatic
    private static final ConcurrentHashMap<InetAddress, String> hostNames = new ConcurrentHashMap();
    private boolean configShown = false;
    private boolean hostnameValidationDisabledLogShown = false;
    private SSLContext sslContext;
    private final SSLConfig sslConfig;
    private ClientSocketFactory clientSocketFactory;
    public static final boolean ENABLE_TCP_KEEP_ALIVE = AdvancedSocketCreatorImpl.ENABLE_TCP_KEEP_ALIVE;

    @Deprecated
    public static InetAddress getLocalHost() throws UnknownHostException {
        return LocalHostUtil.getLocalHost();
    }

    public static String getHostName(InetAddress addr) {
        String result = hostNames.get(addr);
        if (result == null) {
            result = addr.getHostName();
            hostNames.put(addr, result);
        }
        return result;
    }

    public static void resetHostNameCache() {
        hostNames.clear();
    }

    public SocketCreator(SSLConfig sslConfig) {
        this.sslConfig = sslConfig;
        this.initialize();
    }

    @VisibleForTesting
    SocketCreator(SSLConfig sslConfig, SSLContext sslContext) {
        this.sslConfig = sslConfig;
        this.sslContext = sslContext;
    }

    public static String getClientHostName() throws UnknownHostException {
        InetAddress hostAddr = LocalHostUtil.getLocalHost();
        return use_client_host_name ? hostAddr.getCanonicalHostName() : hostAddr.getHostAddress();
    }

    protected void initializeCreators() {
        this.clusterSocketCreator = new SCClusterSocketCreator(this);
        this.clientSocketCreator = new SCClientSocketCreator(this);
        this.advancedSocketCreator = new SCAdvancedSocketCreator(this);
    }

    private void initialize() {
        try {
            try {
                if (this.sslConfig.isEnabled() && this.getSslContext() == null) {
                    this.sslContext = this.createAndConfigureSSLContext();
                }
            }
            catch (Exception e) {
                throw new GemFireConfigException("Error configuring GemFire ssl ", e);
            }
            TCPConduit.init();
            this.initializeClientSocketFactory();
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Error t) {
            SystemFailure.checkFailure();
            t.printStackTrace();
            throw t;
        }
        catch (RuntimeException re) {
            re.printStackTrace();
            throw re;
        }
    }

    private SSLContext createAndConfigureSSLContext() throws GeneralSecurityException, IOException {
        if (this.sslConfig.useDefaultSSLContext()) {
            return SSLContext.getDefault();
        }
        SSLContext newSSLContext = SSLUtil.getSSLContextInstance(this.sslConfig);
        KeyManager[] keyManagers = this.getKeyManagers();
        TrustManager[] trustManagers = this.getTrustManagers();
        newSSLContext.init(keyManagers, trustManagers, null);
        return newSSLContext;
    }

    public static void readSSLProperties(Map<String, String> env) {
        SocketCreator.readSSLProperties(env, false);
    }

    public static void readSSLProperties(Map<String, String> env, boolean ignoreGemFirePropsFile) {
        Properties props = new Properties();
        DistributionConfigImpl.loadGemFireProperties(props, ignoreGemFirePropsFile);
        for (Map.Entry<Object, Object> ent : props.entrySet()) {
            String value;
            String key = (String)ent.getKey();
            if (!key.startsWith("javax.net.ssl") && !key.startsWith("sysprop-")) continue;
            if (key.startsWith("sysprop-")) {
                key = key.substring("sysprop-".length());
            }
            if ((value = (String)ent.getValue()) != null && !value.trim().equals("")) continue;
            Console console = System.console();
            if (console == null) {
                throw new GemFireConfigException("SSL properties are empty, but a console is not available");
            }
            String val = console.readLine("Please enter " + key + ": ", new Object[0]);
            env.put(key, val);
        }
    }

    private TrustManager[] getTrustManagers() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        String trustStoreType = this.sslConfig.getTruststoreType();
        if (StringUtils.isEmpty((CharSequence)trustStoreType)) {
            trustStoreType = KeyStore.getDefaultType();
        }
        KeyStore ts = KeyStore.getInstance(trustStoreType);
        String trustStorePath = this.sslConfig.getTruststore();
        char[] password = null;
        try (FileInputStream fis = new FileInputStream(trustStorePath);){
            String passwordString = this.sslConfig.getTruststorePassword();
            if (passwordString != null) {
                if (passwordString.trim().equals("")) {
                    if (!StringUtils.isEmpty((CharSequence)passwordString)) {
                        String toDecrypt = "encrypted(" + passwordString + ")";
                        passwordString = PasswordUtil.decrypt(toDecrypt);
                        password = passwordString.toCharArray();
                    }
                } else {
                    password = passwordString.toCharArray();
                }
            }
            ts.load(fis, password);
        }
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(ts);
        TrustManager[] trustManagers = tmf.getTrustManagers();
        if (password != null) {
            Arrays.fill(password, ' ');
        }
        return trustManagers;
    }

    private KeyManager[] getKeyManagers() throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        if (this.sslConfig.getKeystore() == null) {
            return null;
        }
        String keyStoreType = this.sslConfig.getKeystoreType();
        if (StringUtils.isEmpty((CharSequence)keyStoreType)) {
            keyStoreType = KeyStore.getDefaultType();
        }
        KeyStore keyStore = KeyStore.getInstance(keyStoreType);
        String keyStoreFilePath = this.sslConfig.getKeystore();
        if (StringUtils.isEmpty((CharSequence)keyStoreFilePath)) {
            keyStoreFilePath = System.getProperty("user.home") + System.getProperty("file.separator") + ".keystore";
        }
        char[] password = null;
        try (FileInputStream fileInputStream = new FileInputStream(keyStoreFilePath);){
            String passwordString = this.sslConfig.getKeystorePassword();
            if (passwordString != null) {
                if (passwordString.trim().equals("")) {
                    String encryptedPass = System.getenv("javax.net.ssl.keyStorePassword");
                    if (!StringUtils.isEmpty((CharSequence)encryptedPass)) {
                        String toDecrypt = "encrypted(" + encryptedPass + ")";
                        passwordString = PasswordUtil.decrypt(toDecrypt);
                        password = passwordString.toCharArray();
                    }
                } else {
                    password = passwordString.toCharArray();
                }
            }
            keyStore.load(fileInputStream, password);
        }
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, password);
        KeyManager[] keyManagers = keyManagerFactory.getKeyManagers();
        if (password != null) {
            Arrays.fill(password, ' ');
        }
        KeyManager[] extendedKeyManagers = new KeyManager[keyManagers.length];
        for (int i = 0; i < keyManagers.length; ++i) {
            extendedKeyManagers[i] = new ExtendedAliasKeyManager(keyManagers[i], this.sslConfig.getAlias());
        }
        return extendedKeyManagers;
    }

    @VisibleForTesting
    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public ClientSocketFactory getClientSocketFactory() {
        return this.clientSocketFactory;
    }

    public SSLConfig getSslConfig() {
        return this.sslConfig;
    }

    protected boolean useSSL() {
        return this.sslConfig.isEnabled();
    }

    public SSLEngine createSSLEngine(String hostName, int port, boolean clientSocket) {
        SSLEngine engine = this.getSslContext().createSSLEngine(hostName, port);
        this.configureSSLEngine(engine, hostName, port, clientSocket);
        return engine;
    }

    @VisibleForTesting
    void configureSSLEngine(SSLEngine engine, String hostName, int port, boolean clientSocket) {
        String[] ciphers;
        String[] protocols;
        SSLParameters parameters = engine.getSSLParameters();
        boolean updateEngineWithParameters = false;
        if (this.sslConfig.doEndpointIdentification() && this.setServerNames(parameters, new HostAndPort(hostName, port))) {
            updateEngineWithParameters = true;
        }
        engine.setUseClientMode(clientSocket);
        if (!clientSocket) {
            engine.setNeedClientAuth(this.sslConfig.isRequireAuth());
        }
        if (clientSocket && this.checkAndEnableHostnameValidation(parameters)) {
            updateEngineWithParameters = true;
        }
        if ((protocols = this.sslConfig.getProtocolsAsStringArray()) != null && !"any".equalsIgnoreCase(protocols[0])) {
            engine.setEnabledProtocols(protocols);
        }
        if ((ciphers = this.sslConfig.getCiphersAsStringArray()) != null && !"any".equalsIgnoreCase(ciphers[0])) {
            engine.setEnabledCipherSuites(ciphers);
        }
        if (updateEngineWithParameters) {
            engine.setSSLParameters(parameters);
        }
    }

    public NioSslEngine handshakeSSLSocketChannel(SocketChannel socketChannel, SSLEngine engine, int timeout, ByteBuffer peerNetBuffer, BufferPool bufferPool) throws IOException {
        while (!socketChannel.finishConnect()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                if (!socketChannel.socket().isClosed()) {
                    socketChannel.close();
                }
                throw new IOException("Interrupted while performing handshake", e);
            }
        }
        NioSslEngine nioSslEngine = new NioSslEngine(engine, bufferPool);
        boolean blocking = socketChannel.isBlocking();
        if (blocking) {
            socketChannel.configureBlocking(false);
        }
        try {
            nioSslEngine.handshake(socketChannel, timeout, peerNetBuffer);
        }
        catch (SSLException e) {
            if (!socketChannel.socket().isClosed()) {
                socketChannel.close();
            }
            logger.warn("SSL handshake exception", (Throwable)e);
            throw e;
        }
        finally {
            if (blocking) {
                try {
                    socketChannel.configureBlocking(true);
                }
                catch (IOException iOException) {}
            }
        }
        return nioSslEngine;
    }

    private boolean checkAndEnableHostnameValidation(SSLParameters sslParameters) {
        if (this.sslConfig.doEndpointIdentification()) {
            sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
            return true;
        }
        if (!this.hostnameValidationDisabledLogShown) {
            logger.info("Your SSL configuration disables hostname validation. ssl-endpoint-identification-enabled should be set to true when SSL is enabled. Please refer to the Apache GEODE SSL Documentation for SSL Property: ssl\u2011endpoint\u2011identification\u2011enabled");
            this.hostnameValidationDisabledLogShown = true;
        }
        return false;
    }

    void handshakeIfSocketIsSSL(Socket socket, int timeout) throws IOException {
        if (!(socket instanceof SSLSocket)) {
            return;
        }
        int oldTimeout = socket.getSoTimeout();
        socket.setSoTimeout(timeout);
        SSLSocket sslSocket = (SSLSocket)socket;
        try {
            sslSocket.startHandshake();
        }
        catch (SSLPeerUnverifiedException ex) {
            if (this.sslConfig.isRequireAuth()) {
                logger.fatal(String.format("SSL Error in authenticating peer %s[%s].", socket.getInetAddress(), socket.getPort()), (Throwable)ex);
                throw ex;
            }
        }
        catch (SSLProtocolException ex) {
            if (ex.getCause() instanceof SocketTimeoutException) {
                throw (SocketTimeoutException)ex.getCause();
            }
            throw ex;
        }
        finally {
            try {
                socket.setSoTimeout(oldTimeout);
            }
            catch (SocketException ex) {}
        }
    }

    public ServerSocket createServerSocket(int nport, int backlog, InetAddress bindAddr, List<GatewayTransportFilter> transportFilters, int socketBufferSize) throws IOException {
        if (transportFilters.isEmpty()) {
            return ((SCClusterSocketCreator)this.forCluster()).createServerSocket(nport, backlog, bindAddr, socketBufferSize, this.useSSL());
        }
        this.printConfig();
        TransportFilterServerSocket result = new TransportFilterServerSocket(transportFilters);
        result.setReuseAddress(true);
        result.setReceiveBufferSize(socketBufferSize);
        try {
            result.bind(new InetSocketAddress(bindAddr, nport), backlog);
        }
        catch (BindException e) {
            BindException throwMe = new BindException(String.format("Failed to create server socket on %s[%s]", bindAddr, nport));
            throwMe.initCause(e);
            throw throwMe;
        }
        return result;
    }

    void configureClientSSLSocket(Socket socket, HostAndPort addr, int timeout) throws IOException {
        block12: {
            if (socket instanceof SSLSocket) {
                String[] ciphers;
                String[] protocols;
                SSLParameterExtension sslParameterExtension;
                SSLSocket sslSocket = (SSLSocket)socket;
                sslSocket.setUseClientMode(true);
                sslSocket.setEnableSessionCreation(true);
                SSLParameters parameters = sslSocket.getSSLParameters();
                boolean updateSSLParameters = this.checkAndEnableHostnameValidation(parameters);
                if (this.setServerNames(parameters, addr)) {
                    updateSSLParameters = true;
                }
                if ((sslParameterExtension = this.sslConfig.getSSLParameterExtension()) != null) {
                    parameters = sslParameterExtension.modifySSLClientSocketParameters(parameters);
                    updateSSLParameters = true;
                }
                if (updateSSLParameters) {
                    sslSocket.setSSLParameters(parameters);
                }
                if ((protocols = this.sslConfig.getProtocolsAsStringArray()) != null && !"any".equalsIgnoreCase(protocols[0])) {
                    sslSocket.setEnabledProtocols(protocols);
                }
                if ((ciphers = this.sslConfig.getCiphersAsStringArray()) != null && !"any".equalsIgnoreCase(ciphers[0])) {
                    sslSocket.setEnabledCipherSuites(ciphers);
                }
                try {
                    if (timeout > 0) {
                        sslSocket.setSoTimeout(timeout);
                    }
                    sslSocket.startHandshake();
                }
                catch (SSLProtocolException ex) {
                    if (ex.getCause() instanceof SocketTimeoutException) {
                        throw (SocketTimeoutException)ex.getCause();
                    }
                    throw ex;
                }
                catch (SSLHandshakeException ex) {
                    logger.fatal(String.format("Problem forming SSL connection to %s[%s].", socket.getInetAddress(), socket.getPort()), (Throwable)ex);
                    throw ex;
                }
                catch (SSLPeerUnverifiedException ex) {
                    if (!this.sslConfig.isRequireAuth()) break block12;
                    logger.fatal("SSL authentication exception.", (Throwable)ex);
                    throw ex;
                }
            }
        }
    }

    private boolean setServerNames(SSLParameters modifiedParams, HostAndPort addr) {
        List<SNIServerName> oldNames = modifiedParams.getServerNames();
        oldNames = oldNames == null ? Collections.emptyList() : oldNames;
        ArrayList<SNIServerName> serverNames = new ArrayList<SNIServerName>(oldNames);
        if (serverNames.stream().mapToInt(SNIServerName::getType).anyMatch(type -> type == 0)) {
            return false;
        }
        String hostName = addr.getHostName();
        if (this.sslConfig.doEndpointIdentification() && InetAddressValidator.getInstance().isValid(hostName)) {
            try {
                hostName = InetAddress.getByName(hostName).getCanonicalHostName();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        serverNames.add(new SNIHostName(hostName));
        modifiedParams.setServerNames(serverNames);
        return true;
    }

    void printConfig() {
        if (!this.configShown && logger.isDebugEnabled()) {
            this.configShown = true;
            StringBuilder sb = new StringBuilder();
            sb.append("SSL Configuration: \n");
            sb.append("  ssl-enabled = ").append(this.sslConfig.isEnabled()).append("\n");
            for (String key : System.getProperties().stringPropertyNames()) {
                if (!key.startsWith("javax.net.ssl")) continue;
                String possiblyRedactedValue = ArgumentRedactor.redactArgumentIfNecessary(key, System.getProperty(key));
                sb.append("  ").append(key).append(" = ").append(possiblyRedactedValue).append("\n");
            }
            logger.debug(sb.toString());
        }
    }

    protected void initializeClientSocketFactory() {
        this.clientSocketFactory = null;
        String className = System.getProperty("gemfire.clientSocketFactory");
        if (className != null) {
            Object o;
            try {
                Class<?> c = ClassPathLoader.getLatest().forName(className);
                o = c.newInstance();
            }
            catch (Exception e) {
                String s = "An unexpected exception occurred while instantiating a " + className + ": " + e;
                throw new IllegalArgumentException(s);
            }
            if (o instanceof ClientSocketFactory) {
                this.clientSocketFactory = (ClientSocketFactory)o;
            } else {
                String s = "Class \"" + className + "\" is not a ClientSocketFactory";
                throw new IllegalArgumentException(s);
            }
        }
    }

    public void initializeTransportFilterClientSocketFactory(GatewaySender sender) {
        this.clientSocketFactory = new TransportFilterSocketFactory().setGatewayTransportFilters(sender.getGatewayTransportFilters());
    }

    private static class ExtendedAliasKeyManager
    extends X509ExtendedKeyManager {
        private final X509ExtendedKeyManager delegate;
        private final String keyAlias;

        ExtendedAliasKeyManager(KeyManager mgr, String keyAlias) {
            this.delegate = (X509ExtendedKeyManager)mgr;
            this.keyAlias = keyAlias;
        }

        @Override
        public String[] getClientAliases(String s, Principal[] principals) {
            return this.delegate.getClientAliases(s, principals);
        }

        @Override
        public String chooseClientAlias(String[] strings, Principal[] principals, Socket socket) {
            if (!StringUtils.isEmpty((CharSequence)this.keyAlias)) {
                return this.keyAlias;
            }
            return this.delegate.chooseClientAlias(strings, principals, socket);
        }

        @Override
        public String[] getServerAliases(String s, Principal[] principals) {
            return this.delegate.getServerAliases(s, principals);
        }

        @Override
        public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
            if (!StringUtils.isEmpty((CharSequence)this.keyAlias)) {
                PrivateKey key = this.delegate.getPrivateKey(this.keyAlias);
                return this.getKeyAlias(keyType, key);
            }
            return this.delegate.chooseServerAlias(keyType, issuers, socket);
        }

        @Override
        public X509Certificate[] getCertificateChain(String s) {
            if (!StringUtils.isEmpty((CharSequence)this.keyAlias)) {
                return this.delegate.getCertificateChain(this.keyAlias);
            }
            return this.delegate.getCertificateChain(s);
        }

        @Override
        public PrivateKey getPrivateKey(String alias) {
            return this.delegate.getPrivateKey(alias);
        }

        @Override
        public String chooseEngineClientAlias(String[] keyTypes, Principal[] principals, SSLEngine sslEngine) {
            return this.delegate.chooseEngineClientAlias(keyTypes, principals, sslEngine);
        }

        @Override
        public String chooseEngineServerAlias(String keyType, Principal[] principals, SSLEngine sslEngine) {
            if (!StringUtils.isEmpty((CharSequence)this.keyAlias)) {
                PrivateKey key = this.delegate.getPrivateKey(this.keyAlias);
                return this.getKeyAlias(keyType, key);
            }
            return this.delegate.chooseEngineServerAlias(keyType, principals, sslEngine);
        }

        private String getKeyAlias(String keyType, PrivateKey key) {
            if (key != null) {
                if (key.getAlgorithm().equals(keyType)) {
                    return this.keyAlias;
                }
                return null;
            }
            return null;
        }
    }
}

