/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.lang;

import java.util.Optional;

public class SystemPropertyHelper {
    public static final String GEODE_PREFIX = "geode.";
    public static final String GEMFIRE_PREFIX = "gemfire.";
    public static final String EVICTION_SCAN_ASYNC = "EvictionScanAsync";
    public static final String EVICTION_SCAN_MAX_THREADS = "EvictionScanMaxThreads";
    public static final String EVICTION_SCAN_THRESHOLD_PERCENT = "EvictionScanThresholdPercent";
    public static final String EVICTION_SEARCH_MAX_ENTRIES = "lru.maxSearchEntries";
    public static final String EARLY_ENTRY_EVENT_SERIALIZATION = "earlyEntryEventSerialization";
    public static final String DEFAULT_DISK_DIRS_PROPERTY = "defaultDiskDirs";
    public static final String HA_REGION_QUEUE_EXPIRY_TIME_PROPERTY = "MessageTimeToLive";
    public static final String THREAD_ID_EXPIRY_TIME_PROPERTY = "threadIdExpiryTime";
    public static final String PERSISTENT_VIEW_RETRY_TIMEOUT_SECONDS = "PERSISTENT_VIEW_RETRY_TIMEOUT_SECONDS";
    public static final String USE_HTTP_SYSTEM_PROPERTY = "useHTTP";
    public static final String PACKAGES_TO_SCAN = "packagesToScan";
    public static final String PARALLEL_DISK_STORE_RECOVERY = "parallelDiskStoreRecovery";

    public static Optional<Boolean> getProductBooleanProperty(String name) {
        String property = SystemPropertyHelper.getProperty(name);
        return property != null ? Optional.of(Boolean.parseBoolean(property)) : Optional.empty();
    }

    public static Optional<Integer> getProductIntegerProperty(String name) {
        Integer propertyValue = Integer.getInteger(GEODE_PREFIX + name);
        if (propertyValue == null) {
            propertyValue = Integer.getInteger(GEMFIRE_PREFIX + name);
        }
        if (propertyValue != null) {
            return Optional.of(propertyValue);
        }
        return Optional.empty();
    }

    public static Optional<String> getProductStringProperty(String name) {
        String property = SystemPropertyHelper.getProperty(name);
        return property != null ? Optional.of(property) : Optional.empty();
    }

    public static String getProperty(String name) {
        String property = SystemPropertyHelper.getGeodeProperty(name);
        return property != null ? property : SystemPropertyHelper.getGemfireProperty(name);
    }

    private static String getGeodeProperty(String name) {
        return System.getProperty(GEODE_PREFIX + name);
    }

    private static String getGemfireProperty(String name) {
        return System.getProperty(GEMFIRE_PREFIX + name);
    }

    public static boolean restoreSetOperationTransactionBehavior() {
        return SystemPropertyHelper.getProductBooleanProperty("restoreSetOperationTransactionBehavior").orElse(false);
    }

    public static boolean restoreIdleExpirationBehavior() {
        return SystemPropertyHelper.getProductBooleanProperty("restoreIdleExpirationBehavior").orElse(false);
    }
}

