/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.datasource;

import java.io.Serializable;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.XADataSource;
import org.apache.geode.internal.datasource.ConfiguredDataSourceProperties;
import org.apache.geode.internal.datasource.ConnectionPoolCache;
import org.apache.geode.internal.datasource.ConnectionPoolCacheImpl;
import org.apache.geode.internal.datasource.ConnectionProvider;
import org.apache.geode.internal.datasource.PoolException;
import org.apache.geode.internal.datasource.TranxPoolCacheImpl;

public class GemFireConnectionPoolManager
implements ConnectionProvider,
Serializable {
    private static final long serialVersionUID = 23723212980453813L;
    protected ConnectionPoolCache connPoolCache;

    public GemFireConnectionPoolManager(ConnectionPoolDataSource connPool, ConfiguredDataSourceProperties configs, ConnectionEventListener listener) throws PoolException {
        this.connPoolCache = new ConnectionPoolCacheImpl(connPool, listener, configs);
    }

    public GemFireConnectionPoolManager(XADataSource connPool, ConfiguredDataSourceProperties configs, ConnectionEventListener listener) throws PoolException {
        this.connPoolCache = new TranxPoolCacheImpl(connPool, listener, configs);
    }

    @Override
    public Object borrowConnection() throws PoolException {
        return this.connPoolCache.getPooledConnectionFromPool();
    }

    @Override
    public void returnAndExpireConnection(Object connectionObject) {
        this.connPoolCache.expirePooledConnection(connectionObject);
    }

    @Override
    public void returnConnection(Object connectionObject) {
        this.connPoolCache.returnPooledConnectionToPool(connectionObject);
    }

    public ConnectionPoolCache getConnectionPoolCache() {
        return this.connPoolCache;
    }

    @Override
    public void clearUp() {
        this.connPoolCache.clearUp();
    }
}

