/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.ha;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.geode.DataSerializer;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.MessageWithReply;
import org.apache.geode.distributed.internal.PooledDistributionMessage;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.HARegion;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.ha.HARegionQueue;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.util.internal.UncheckedUtils;
import org.apache.logging.log4j.Logger;

public class QueueSynchronizationProcessor
extends ReplyProcessor21 {
    private static final Logger logger = LogService.getLogger();
    QueueSynchronizationReplyMessage reply;

    QueueSynchronizationProcessor(DistributionManager dm, InternalDistributedMember primary) {
        super(dm, primary);
    }

    static List<EventID> getDispatchedEvents(DistributionManager dm, InternalDistributedMember primary, String regionName, List<EventID> events) {
        QueueSynchronizationProcessor processor = new QueueSynchronizationProcessor(dm, primary);
        QueueSynchronizationMessage message = new QueueSynchronizationMessage();
        message.setEventIdList(events);
        message.setProcessorId(processor.getProcessorId());
        message.setRegionName(regionName);
        message.setRecipient(primary);
        dm.putOutgoing(message);
        try {
            processor.waitForRepliesUninterruptibly();
        }
        catch (ReplyException e) {
            e.handleCause();
        }
        if (processor.reply != null) {
            return processor.reply.getDispatchedEvents();
        }
        return null;
    }

    @Override
    public void process(DistributionMessage msg) {
        try {
            this.reply = (QueueSynchronizationReplyMessage)msg;
        }
        finally {
            super.process(msg);
        }
    }

    public static class QueueSynchronizationReplyMessage
    extends ReplyMessage {
        private List<EventID> events;
        private boolean succeed = false;

        void setEventIds(List<EventID> events) {
            this.events = events;
        }

        List<EventID> getDispatchedEvents() {
            return this.events;
        }

        void setSuccess() {
            this.succeed = true;
        }

        @Override
        public int getDSFID() {
            return -17;
        }

        @Override
        public void toData(DataOutput out, SerializationContext context) throws IOException {
            super.toData(out, context);
            DataSerializer.writeBoolean(this.succeed, out);
            if (this.succeed) {
                DataSerializer.writeInteger(this.events.size(), out);
                for (EventID eventId : this.events) {
                    DataSerializer.writeObject(eventId, out);
                }
            }
        }

        @Override
        public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
            super.fromData(in, context);
            this.succeed = DataSerializer.readBoolean(in);
            if (this.succeed) {
                this.events = new LinkedList<EventID>();
                int size = DataSerializer.readInteger(in);
                for (int i = 0; i < size; ++i) {
                    this.events.add((EventID)UncheckedUtils.uncheckedCast(DataSerializer.readObject(in)));
                }
            }
        }
    }

    public static class QueueSynchronizationMessage
    extends PooledDistributionMessage
    implements MessageWithReply {
        private List<EventID> eventIds;
        private int processorId;
        private String regionName;

        void setEventIdList(List<EventID> message) {
            this.eventIds = message;
        }

        void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        void setProcessorId(int processorId) {
            this.processorId = processorId;
        }

        @Override
        protected void process(ClusterDistributionManager dm) {
            QueueSynchronizationReplyMessage replyMessage = this.createQueueSynchronizationReplyMessage();
            ReplyException replyException = null;
            InternalCache cache = dm.getCache();
            try {
                List<EventID> dispatched;
                if (cache != null && (dispatched = this.getDispatchedEvents(cache)) != null) {
                    replyMessage.setEventIds(dispatched);
                    replyMessage.setSuccess();
                }
            }
            catch (Error | RuntimeException e) {
                replyException = new ReplyException(e);
                throw e;
            }
            finally {
                replyMessage.setProcessorId(this.processorId);
                replyMessage.setRecipient(this.getSender());
                if (replyException != null) {
                    replyMessage.setException(replyException);
                }
                dm.putOutgoing(replyMessage);
            }
        }

        QueueSynchronizationReplyMessage createQueueSynchronizationReplyMessage() {
            return new QueueSynchronizationReplyMessage();
        }

        List<EventID> getDispatchedEvents(InternalCache cache) {
            LocalRegion region = (LocalRegion)cache.getRegion(this.regionName);
            if (region == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("processing QueueSynchronizationMessage region {} does not exist.", (Object)this.regionName);
                }
                return null;
            }
            HARegionQueue haRegionQueue = ((HARegion)region).getOwner();
            return haRegionQueue.getDispatchedEvents(this.eventIds);
        }

        public int getDSFID() {
            return -18;
        }

        @Override
        public int getProcessorId() {
            return this.processorId;
        }

        @Override
        public void toData(DataOutput out, SerializationContext context) throws IOException {
            super.toData(out, context);
            DataSerializer.writeString(this.regionName, out);
            DataSerializer.writeInteger(this.processorId, out);
            int numberOfIds = this.eventIds.size();
            DataSerializer.writeInteger(numberOfIds, out);
            for (EventID eventId : this.eventIds) {
                DataSerializer.writeObject(eventId, out);
            }
        }

        @Override
        public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
            super.fromData(in, context);
            this.eventIds = new LinkedList<EventID>();
            this.regionName = DataSerializer.readString(in);
            this.processorId = DataSerializer.readInteger(in);
            int size = DataSerializer.readInteger(in);
            for (int i = 0; i < size; ++i) {
                this.eventIds.add((EventID)UncheckedUtils.uncheckedCast(DataSerializer.readObject(in)));
            }
        }
    }
}

