/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.cache.TransactionId;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.DSFIDFactory;
import org.apache.geode.internal.ExternalizableDSFID;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.serialization.SerializationContext;

public class TXId
extends ExternalizableDSFID
implements TransactionId {
    private InternalDistributedMember memberId;
    private int uniqId;

    public TXId() {
    }

    public TXId(InternalDistributedMember memberId, int uniqId) {
        this.memberId = memberId;
        this.uniqId = uniqId;
    }

    @Override
    public InternalDistributedMember getMemberId() {
        return this.memberId;
    }

    public String toString() {
        return "TXId: " + this.memberId + ':' + this.uniqId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TXId)) {
            return false;
        }
        TXId otx = (TXId)o;
        return otx.uniqId == this.uniqId && (otx.memberId == null && this.memberId == null || otx.memberId != null && this.memberId != null && otx.memberId.equals(this.memberId));
    }

    public int hashCode() {
        int retval = this.uniqId;
        if (this.memberId != null) {
            retval = retval * 37 + this.memberId.hashCode();
        }
        return retval;
    }

    @Override
    public int getDSFID() {
        return 109;
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        out.writeInt(this.uniqId);
        InternalDataSerializer.invokeToData(this.memberId, out);
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        this.uniqId = in.readInt();
        this.memberId = DSFIDFactory.readInternalDistributedMember(in);
    }

    public static TXId createFromData(DataInput in) throws IOException, ClassNotFoundException {
        TXId result = new TXId();
        InternalDataSerializer.invokeFromData(result, in);
        return result;
    }

    public int getUniqId() {
        return this.uniqId;
    }

    public KnownVersion[] getSerializationVersions() {
        return null;
    }
}

