/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.apache.geode.distributed.internal.AdminMessageType;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.HighPriorityDistributionMessage;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.admin.remote.AdminWaiters;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;

public abstract class AdminResponse
extends HighPriorityDistributionMessage
implements AdminMessageType {
    private int msgId;

    int getMsgId() {
        return this.msgId;
    }

    public void setMsgId(int msgId) {
        this.msgId = msgId;
    }

    @Override
    public boolean sendViaUDP() {
        return true;
    }

    @Override
    protected void process(ClusterDistributionManager dm) {
        AdminWaiters.sendResponse(this);
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        out.writeInt(this.msgId);
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.msgId = in.readInt();
    }

    public InternalDistributedMember getRecipient() {
        List<InternalDistributedMember> recipients = this.getRecipients();
        int size = recipients.size();
        if (size == 0) {
            return null;
        }
        if (size > 1) {
            throw new IllegalStateException(String.format("Could not return one recipient because this message has %s recipients", size));
        }
        return recipients.get(0);
    }
}

